<?php
/*
 Ajax Chat for TRPG ver.2.6.2
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*****************
 *  設定ファイル：共通
 *****************/

/* 以下、重要な設定 */
// 管理者用パスワード
define('MASTERPASS', 'password');

// パスワードの暗号化キー
// 4文字以上入力してください
define('ADMIN_HASH_KEY', 'ajaxchat');

// クッキー名
define('COOKIE', 'AjaxChat'); // 空:クッキーを使用しない

// 直近の過去ログを難読化する
// 直近の過去ログファイルを普通には読めないように変換して保管します。
// ＊注意＊
// .htaccessが使えるならば、.htaccessのみで直近の過去ログへのダイレクトアクセスを禁止することをお勧めします。
// この機能を用いると、負荷が高くなります。また、トラブルが起こった時にログの復元がしずらくなります。
// また、完全な暗号化ではありません。「読みずらく」しているだけです。
//  難読化している場合、今後のバージョンアップ時にHTML化していない過去ログは、引き継げない場合がありえます。ご了承ください。
//  この設定を途中で変更すると、HTML化していない過去ログが読めなくなります。
define('OBFUSCATION', '0');

/* ここまで、重要な設定 */

// ファイル名
    // 設定ファイル：重要
define('CONFIG_IMPORTANT', './config-data-important.php');
    // 設定ファイル：タグ
define('CONFIG_TAG', './config-data-tag.php');
    // 設定ファイル：TRPG
define('CONFIG_TRPG', './config-data-trpg.php');
    // 設定ファイル：カード機能
define('CONFIG_CARD', './config-data-card.php');
    // 設定ファイル：全体の配色
define('CONFIG_BASE_COLOR', './config-data-base-color.php');
    // 設定ファイル：チャット画面の配色
define('CONFIG_MAIN_COLOR', './config-data-main-color.php');
    // 設定ファイル：全般
define('CONFIG_MAIN', './config-data-main.php');
    // 設定ファイル：アイコン
define('CONFIG_ICON', './config-data-icon.php');
    // 設定ファイル：携帯
define('CONFIG_MOBILE', './config-data-mobile.php');
    // 最新ログファイル名
define('RECENT_LOG', './trpgchat.log');
    // 直近の過去ログファイル名
define('PAST_LOG', './trpgchat_past.log');
    // HTML化過去ログ保管ディレクトリ
define('PAST_DIR', './past/');
    // 管理用過去ログ保管ディレクトリ
define('MASTER_PAST_DIR', './master_past/');
    // メンバーチェッカーログファイル名
define('NOW_MEMBER', './member.log');
    // システムログファイル名
define('SYSTEM_LOG', './system.log');
    // ロックファイル
define('LOCK', './lock.txt');
define('LOCK2', './lock2.txt');
define('LOCK3', './lock3.txt');
    // カード設定保管ディレクトリ
define('CARD_DIR', './lib/card/');
    // 現在のデックファイル名
define('NOW_DECK', './deckset.json');
    // 現在のデック（カード）所持状態ファイル名
define('NOW_DECK_STATUS', './deck_status.json');

require_once './trpgchat-ini-2.php';

