<?php
/*
 * Link Plugin for TRPG Databank
 * 
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Model
 * @package  plugin for TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

class Link extends AppModel {
	public $name = 'Link';

	var $actsAs = array(
//		'Utils.Pingbackable',
//		'tags.taggable',
	);

	var $displayField = 'title';

	public $fields = array(
		'add' => array('user_id', 'url', 'title', 'notes', 'type'),
		'edit' => array('url', 'title', 'notes', 'type'),
		'admin_add' => array('user_id', 'url', 'title', 'notes', 'type', 'ring', 'pickup'),
		'admin_edit' => array('url', 'title', 'notes', 'type', 'ring', 'pickup'),
		'image' => array(
			'user_id',
			'model',
			'foreign_key',
			'dirname',
			'basename',
			'checksum',
			'size',
			'group',
			'alternative',
			'file',
		),
		'escape' => array(
			'title' => array(
				'html' => true,
				'tags' => true,
				'all' => true,
			),
			'notes' => array(
				'html' => true,
				'tags' => true,
				'images' => true,
				'sctipts' => true,
			),
			'ring' => array(
				'html' => false,
				'tags' => false,
				'images' => false,
				'sctipts' => false,
			),
		),
	);


	// リンク種類
	public $type = array(
		0 => 'member',
		10 => 'portal',
		20 => 'online',
		25 => 'offline',
		30 => 'tool',
		40 => 'creator',
		45 => 'shop',
		100 => 'ring',
		110 => 'thanks',
	);

	var $validate = array(
		'url' => array(
			'isUnique' => array(
				'rule' => array('isUnique'),
				'required' => true,
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
			'maxLength' => array(
				'rule' => array('maxLength', 512),
			),
			'url' => array(
				'rule' => array('url'),
			),
		),
		'type' => array(
			'validType' => array(
				'rule' => array('validType'),
			),
		),
		'pickup' => array(
			'boolean' => array(
				'rule' => array('boolean'),
			),
		),
		'not_found' => array(
			'boolean' => array(
				'rule' => array('boolean'),
			),
		),
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed

	public $belongsTo = array(
		'User' => array(
			'className' => 'User',
			'foreignKey' => 'user_id',
			'conditions' => '',
			'fields' => array(
				'User.id', 
				'User.name'
			),
			'order' => ''
		)
	);

	public $hasMany = array(
/*		'TmpLink' => array(
			'className' => 'TmpLink',
			'foreignKey' => 'link_id',
			'dependent' => false,
			'conditions' => array(
			),
			'fields' => array(
				'TmpLink.id',
				'TmpLink.checked',
				'TmpLink.created',
			),
			'order' => array('TmpLink.id' => 'desc'),
			'limit' => '',
			'offset' => '',
			'dependent' => false,
			'finderQuery' => '',
			'deleteQuery' => '',
			'insertQuery' => ''
		),*/
		// ロゴ
		'Attachment' => array(
			'className' => 'Media.AttachmentEx',
			'foreignKey' => 'foreign_key',
			'dependent' => true,
			'conditions' => array('Attachment.model' => 'Link'),
			'fields' => array(
				'Attachment.id',
				'Attachment.user_id',
				'Attachment.foreign_key',
				'Attachment.dirname',
				'Attachment.basename',
				'Attachment.alternative',
				'Attachment.size',
				'Attachment.created',
			),
			'order' => '',
			'limit' => '',
			'offset' => '',
			'dependent' => true,
		)
	);

	// Options for CollectionableBehavoir
	var $defaultOption = true;
	var $options = array(
		'default' => array(
			'conditions' => array(
			),
			'fields' => array(
			),
			'recursive' => 1,
			'contain' => array(
				'User',
				'Attachment',
			),
			'limit' => 10,
			'order' => array(
				'Link.modified' => 'desc',
			),
		),
		// general
		'pickup' => array(
			'conditions' => array(
				'Link.pickup' => 1,
			),
		),
		'only_found' => array(
			'conditions' => array(
				'Link.not_found' => 0,
			),
		),
		'only_notfound' => array(
			'conditions' => array(
				'Link.not_found' => 1,
			),
		),
		// limit
		'limit5' => array(
			'limit' => 5,
		),
		'limit9' => array(
			'limit' => 9,
		),
		'unlimited' => array(
			'limit' => null,
		),
	);

	/* コールバックメソッド */

	function beforeValidate($options = array())
	{
		// URLのエンコード
//		$this->data['Link']['url'] = urlencode(mb_convert_encoding($this->data['Link']['url'], 'UTF-8', 'auto'));

		$this->data['Link']['url'] = $this->mb_urlEncode($this->data);

		return parent::beforeValidate($options);
	}

	function beforeSave($options = array())
	{

		return parent::beforeSave($options);
	}

	function beforeFind($queryData) {
		foreach ($this->type as $id => $type) {
			$this->options = array_merge($this->options, array(
				// by type
				$type => array(
					'conditions' => array(
						'Link.type' => $id,
					),
				),
			));
		}

		return parent::beforeFind($queryData);
	}


	/* validate */
	function validType($data) {
		if (!isset($data["type"])) {
			return true;
		}

		$params = Router::getParams();
		if (isset($params->admin)) {
			if (!in_array($data["type"], array_keys($this->type))) {
				return false;
			}
		}
		unset($data["type"]);

		return true;
	}


	/* URLのマルチバイトを変換 */
	function mb_urlEncode($data) {
		if (!isset($data['Link']['url'])) {
		}

		return preg_replace_callback(
			'/[^\x21-\x7e]+/',
			array($this, '_mb_urlEncode'),
			$data['Link']['url']
		);
	}
	function _mb_urlEncode($data) {
		$converted = mb_convert_encoding($data[0], 'UTF-8', 'auto');

		return rawurlencode($converted);
	}

}

