<?php 
/*
 * Link Plugin for TRPG Databank
 * 
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Element
 * @package  plugin for TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

if (!empty($link['Link']['title'])) {
	$title = $this->Text->truncate($link['Link']['title'], $length, array(
		'html' => true,
	));
} else {
	$title = __('No Title', true);
}
?>
<td class="banner">
<?php
if (!empty($link['Attachment'])) {
	echo $this->element('link_banner', array(
		'attachment' => $link['Attachment'][0],
		'name' => $title,
		'options' => array(
			'url' => $url,
			'htmlAttributes' => array(
				'title' => $title,
			),
		)
	));
}
?>
</td>
<td class="linkInfo">
<?php if(!empty($link['Link'])): ?>
<div class="linkTitle"><?php
	//echo $link['Link']['not_found'];
	echo $this->Html->link($title, $url, array(
		'target' => '_blank',
	));
?></div>
<div class="linkUrl linkUrlSmall"><?php echo $link['Link']['url']; ?></div>
<?php endif; ?>
</td>
