<?php
/**
 * Extend of Attachment Model File
 */
app::import('Media.Attachment');
class AttachmentEx extends Attachment {
	var $name = 'AttachmentEx';

	var $belongsTo = array(
		'User' => array(
			'className' => 'User',
			'foreignKey' => 'user_id',
			'conditions' => '',
			'fields' => '',
			'order' => ''
		)
	);

	function __construct($id = false, $table = null, $ds = null) {

		// Uploadファイルの保存設定
		// ファイル名
//		$this->actsAs['Media.Transfer']['destinationFile'] = ':Medium.short::DS::uuid:'.'.'.':Source.extension:';

		// validate
		$this->validate['file']['extension'] = array('rule' => array('checkExtension', false, array(
			'jpg', 'jpeg', 'png', 'gif',
		)));
		$this->validate['file']['notEmpty'] = array('rule' => array('checkMimeType', false, array(
			'image/jpeg', 'image/png', 'image/gif'
		)));

		parent::__construct($id, $table, $ds);
	}

	function beforeValidate(&$Model) {
			/* 新規追加の場合 */
			if (isset($this->data['Attachment']['file'])) {
				// ファイルサイズ
				if (isset($this->data['Attachment']['file']['size'])) {
					$this->data['Attachment']['size'] = $this->data['Attachment']['file']['size'];
				}

				/* 追加validate */
				// ファイル容量
				$filesize = Configure::read('Upload.imagefile.FileSizeMax');
				if (empty($filesize) || $filesize <= 0) {
					unset($this->validate['file']['size']);
				} else {
					$this->validate['file']['size']['rule'] = array('checkSize', $filesize.'K');
				}

				//ファイルサイズ
				$width = Configure::read('Upload.imagefile.WidthMax');
				$height = Configure::read('Upload.imagefile.HeightMax');
				if ((empty($width) || $width <= 0) || (empty($height) || $height <= 0)) {
					unset($this->validate['file']['pixels']);
				} else {
					$this->validate['file']['pixels']['rule'] = array('checkPixels', $width.'x'.$height);
				}
			}

		return parent::beforeValidate();
	}

	function beforeSave($options = array()) {
		if (isset($this->data[$this->alias])
		 && (!isset($this->data[$this->alias]['delete']) 
		 || ($this->data[$this->alias]['file']))) {
			// 登録者ID
			if (isset($_SESSION['Auth']['User']['id'])) {
				$this->data[$this->alias]['user_id'] = $_SESSION['Auth']['User']['id'];
			}
		}

		return parent::beforeSave($options);
	}

	function beforeDelete(&$Model, $cascade = true) {
		$target = $this->find('first', array(
			'conditions' => array('id' => $this->data[$this->alias]['id']),
			'fields'     => array('user_id', 'dirname', 'basename'),
			'recursive'  => -1,
		));

		// Versionファイル削除
		$FilterFolder =& new Folder(Folder::slashTerm(MEDIA_FILTER));
		list($versions, $files) = $FilterFolder->read();
		foreach ($versions as $version) {
			$FilterFile = new File(MEDIA_FILTER . $version. DS . $target[$this->alias]['dirname'] . DS. $target[$this->alias]['basename']);
			$FilterFile->delete();
		}

		if (isset($this->data[$this->alias]['isAdmin']) && $this->data[$this->alias]['isAdmin'] == true) {
			return parent::beforeDelete($cascade);
		}

		if (!isset($this->data[$this->alias]['id']) || empty($this->data[$this->alias]['id'])) {
			return false;
		}

		if ($target[$this->alias]["user_id"] != $_SESSION['Auth']['User']['id']) {
			return false;
		}

		return parent::beforeDelete($cascade);
	}

}
