<div class="characterProfileArchives view">
<?php 
	$id = 'characterProfileArchiveInfo';

	$title = $characterProfileArchive['CharacterProfileArchive']['title'];

	$date = sprintf(__('<span class="link">%s on %s</span>', true),
		 $html->link(
		 	$characterProfileArchive['Character']['name'], 
			array(
				'controller' => 'characters', 
					'action' => 'view', 
			$characterProfileArchive['Character']['id']
			), array('escape' => false), false
		),
		$time->niceShort(
			$characterProfileArchive['CharacterProfileArchive']['disp_date'],
			array('format' => 'Y/m/d H:i')
		)
	);
	if ($isOwner || $isAdmin) {
		$date .= sprintf(__('<span id="modified">(created at %s)</span>', true),
			$time->niceShort(
				$characterProfileArchive['CharacterProfileArchive']['created'],
				array('format' => 'Y/m/d H:i')
			)
		);
	}

	$public = '';
	if ($isOwner || $isAdmin) {
		$public = $html->tag(
			'span',
			$select->get_i18n_unpublic_flag($characterProfileArchive['CharacterProfileArchive']['public_flag'], $public_flags),
			array('class' => 'publicFlag')
		);
	}

	$footer = '<div class="actions"><ul>';

	if ($isOwner) {
		$footer .= '<li>'.$html->link(__('Edit CharacterProfileArchive', true), array('action' => 'edit', $characterProfileArchive['CharacterProfileArchive']['id'])).'</li>';
	}
	if ($isOwner || $isAdmin) {
		$footer .= '<li>'.$html->link(__('Delete CharacterProfileArchive', true), array('action' => 'delete', $characterProfileArchive['CharacterProfileArchive']['id']), null, __('Are you sure you want to delete it?', true)).'</li>';
	}

	$footer .= '<li>'.$html->link(
		__('List Archives', true),
		array(
			'controller' => 'character_profile_archives',
			'action' => 'index',
			$characterProfileArchive['Character']['id'],
		)
	). '</li>';
	$footer .= '<li>'.$html->link(
		sprintf(__("%s's Home", true), $characterProfileArchive['Character']['name']),
		array(
			'controller' => 'characters',
			'action' => 'view',
			$characterProfileArchive['Character']['id'],
		)
	). '</li>';

	$footer .= '</ul></div>';

	echo $this->element('box', array(
		'id' => $id,
		'header' => $title. $date. $public,
		'body' => $characterProfileArchive['CharacterProfileArchive']['memo']. "&nbsp;",
		'footer' => $footer,
	));
 ?>
</div>

<?php if (!empty($characterProfileArchive['CharacterProfileArchive']['value'])): ?>
<?php

	$character = $characterProfileArchive['CharacterProfileArchive']['value'];

	echo $this->element(
		'character_view',
		array(
			'character' => $character,
			'isOwner' => $isOwner,
			'isAdmin' => $isAdmin,
			'isArchive' => true,
		)
	);
?>
<?php endif; ?>
