<?php
/**
 * CakePHP 1.3 + PHP 5
 * 
 * @copyright Copyright 2010, Takayuki Miwa http://github.com/tkyk/
 * @license http://www.opensource.org/licenses/mit-license.php The MIT License
 */

class ComponentTestCase_TestController extends Controller {}

abstract class ComponentTestCase extends CakeTestCase {
    var $Controller;
    var $components = array();
    var $uses = array();
    var $controllerClassName = 'ComponentTestCase_TestController';
  
    protected function _createController($components, $controllerCn = null) {
        $cls = empty($controllerCn) ? $this->controllerClassName : $controllerCn;
        $Controller = new $cls;
        if(empty($Controller->uses)) {
            $Controller->uses = $this->uses;
        }
        $Controller->components = $components;
        $Controller->constructClasses();
        $Controller->Component->initialize($Controller);
        return $Controller;
    }

    function startTest($m) {
        if(!empty($this->components)) {
            $this->Controller = $this->_createController($this->components);
            $this->__setComponents();
        }
    }

    private function __setComponents($unset=false) {
        foreach(Set::normalize($this->components) as $key => $_x) {
            list($plugin, $key) = pluginSplit($key);
            if($unset) {
                unset($this->{$key});
            } else {
                $this->{$key} = $this->Controller->{$key};
            }
        }
    }

   function endTest() {
        if(!empty($this->Controller)) {
            unset($this->Controller);
            $this->__setComponents(true);
        }
        ClassRegistry::flush();
    }
}
