<?php
/*
 Ajax Chat for TRPG ver.2.7
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */
/*******************
 *  カード機能アクション：ユーザによるカード追加
 *******************/

Controller::setAjaxAction();

// 管理設定(使用可不可）のチェック
if (!ALLOW_USER_CARD_ADD) {
    throw new Return_Exception('カード追加機能は現在使用できません。');
}

// 実行者の参加状態チェック
$post->check_dealer();
$executant->check_only_member($member);

// 受信データ読込みと成形
$file = $post->get_file();
$card_arr = array();
$postToCard = new PostToCard();
$type = $posts['t'];

// フォーム入力によるカード追加
if (!$file) {

    // 受信情報をカード配列化
    $data = $postToCard->check_post_card_data($posts);

    $postToCard->set_new_card4post($data, $type);

// ファイルアップロードによるカード追加
} else {
    if  (!$file['deckfile']['name']) {
//            error('ファイルを指定して下さい', true);
    }
    // アップロードファイル読込み
    $upfile = save_upload_card_inifile($file['deckfile']);
    if ($upfile['error']) {
//            error($ini['error'], true);
    }
}

$add_deckset = $postToCard->get_add_deckset();

if ($add_deckset) {

    // カード設定に追加
    $iniFile = new DeckIniFiler();

    // ファイルロック
    $lfp = $iniFile->fileLock(LOCK3);

    $deck = new Deck();

    $deck->set_deckset(false);
    $deck->set_deckstatus(false);
    $deck->set_new_deck($add_deckset);

    // ファイル書込み
    $deckset = Tw_JSON::set_array2json($deck->get_new_deskset());
    $iniFile->fileWrite(NOW_DECK, $deckset, 'w', 'close');

    $deck_status = Tw_JSON::set_array2json($deck->get_new_deckstatus());
    $iniFile->fileWrite(NOW_DECK_STATUS, $deck_status, 'w', 'close');

    // ロック解除
    $iniFile->fileUnlock($lfp);
}

// チャットに操作内容を書込み
$writeToChat = new WriteToChat();
$error = $postToCard->get_error();
if ($error) {
    $writeToChat->set_msg($error, 'error');
}
$add_cards = $deck->get_handled_cards();
if ($add_cards) {
    $writeToChat->set_msg('デックに'.count($add_cards).'枚カードを追加しました');
    $writeToChat->set_msg('追加したカード：'.implode('、', $add_cards), 'after', 1, true);
}

if ($msg = $writeToChat->get_msg()) {
     echo Tw_JSON::set_array2json($msg);
}

exit;
