<?php
/*
 Ajax Chat for TRPG ver.2.7
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */
/*******************
 *  カード機能：カード追加
 *******************/

// 基本設定
define('BASE_DIR', realpath('./'). '/');
define('LIB_DIR', BASE_DIR. 'lib/');

// 共通設定ファイルの読み込み
require_once LIB_DIR. 'init.php';
//require_once LIB_DIR. 'card.php';

// デバッグ用設定
ini_set('log_errors', DEVELOP_MODE);
ini_set('error_log', BASE_DIR. "php_error.log");

try {
    // POST受信
    $post =& Tw_Post::getInstance();
    $posts = $post->get_posts();

    // 実行者
    $member = new Tw_Members;
    $executant =& Tw_Executant::getInstance($posts['n']);

    // アクションファイル読み込み
    $app = loading_app($posts['a'], $posts['d']);
    if ($app) {
        require_once $app;
    } else {
        throw new Exception($posts['a']. "に対応するアクションファイルがありません");
    }

} catch (CloseWindow_Exception $e_close) {
    Controller::error_con($e_close->getMessage(), false, true);
} catch (Return_Exception $e_reload) {
    Controller::error_con($e_reload->getMessage(), true);
} catch (Reload_Exception $e_return) {
    Controller::error_con($e_return->getMessage(), false, true, true);
} catch (Exception $e) {
    Controller::error_con($e->getMessage());
}

exit;
