<?php
/*
 Ajax Chat for TRPG ver.2.6.2
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */
/*******************
 *  カード機能：パスワード付きデックの表示
 *******************/

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/card.php';

// 受信データの成形
if (!$_POST) {
    error('リクエストを受信できません', true);
}
if (!$_POST['deck_pwd']) {
    error('パスワードを入力してください', true);
}

// 設定セット
$msg_prefix= '['.basename($_SERVER['SCRIPT_NAME']).']';
set_config(read_config());

// 管理設定のチェック
if (!USE_SECRET_DECK) {
    error('この機能は現在使用できません。');
}

// アクセスブロック
access_block();

// 受信パスワードを暗号化してセッションに入れる
set_user_password($_POST['deck_pwd']);

// 操作のシステムログ書込み
write_syslog('Try to read Protected Card by Password, from');

// カード表示に戻る
$self_url = get_self_url();
$url = str_replace('card_deck_auth.php', '', $self_url).'card.php';

header('Location: '. $url);
exit;

