<?php
/*
 Ajax Chat for TRPG ver.2.6.2
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */
/*******************
 *  カード機能：カード更新（全てのカードを戻す）
 *******************/

// デバッグ用設定
ini_set('log_errors', false);
ini_set('error_log', "./php_error.log");

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/member_check.php';
require_once './lib/card.php';

// 受信データの成形
if (!$request = request()) {
    error('リクエストを受信できません', true);
}

// 設定セット
set_config(read_config());

// 書き込みブロック
write_block();

// アクセスブロック
access_block();

// 実行者チェック
$plname = htmlspecialchars($request['n']);
if (!$plname) {
    error('チャットに参加してください', true);
}

// 難読化
if (OBFUSCATION) {
    $deckOwner = obf_xor('deckCardSet');
    $plname = obf_xor($plname);
} else {
    $deckOwner = 'deckCardSet';
}

// メンバーチェック
$now_member = get_member_log();
$members = array();
$member_flag = false;
foreach($now_member as $v) {
    $members[] = $v[0];
    if ($plname == $v[0]) {
        $member_flag = true;
        break;
    }
}
if (!$member_flag) {
    error('カード操作変更は参加者のみ可能です', true);
}

// カード移動
// ファイルロック
$lfp = fopen(LOCK3,"w");
stream_set_write_buffer($lfp, 0);
flock($lfp,LOCK_EX);

// 現在のカード状態
$deck_status_json = file_get_contents(NOW_DECK_STATUS);
$deck_status = set_json2array($deck_status_json);

if (!$deck_status) {
    error('現在のカード状態設定がありません', true);
}

// カード操作
foreach ($deck_status as $k => $v) {
    if ($k != $deckOwner && $deck_status[$k]['Secret']['card']) {
        $deck_status[$deckOwner]['Secret']['card'] = array_merge($deck_status[$deckOwner]['Secret']['card'], $deck_status[$k]['Secret']['card']);
        unset($deck_status[$k]['Secret']['card']);
    }
    if ($deck_status[$k]['Field']['card']) {
        $deck_status[$deckOwner]['Secret']['card'] = array_merge($deck_status[$deckOwner]['Secret']['card'], $deck_status[$k]['Field']['card']);
        unset($deck_status[$k]['Field']['card']);
    }
}

// カード操作結果の書き込み
$fp = @fopen(NOW_DECK_STATUS, "w") or error("カード状態ファイルを開けません。", true);
fwrite($fp, set_array2json($deck_status));
fclose($fp);

// ロック解除
fflush($lfp);
fclose($lfp);

$write_msg[0]['msg'] = "全てのカードを山に戻しました。";
echo set_array2json($write_msg);

exit;
