<?php
/*
 Ajax Chat for TRPG ver.2.7
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*
 * Controller
 */


/* クラスファイルautoload */
function __autoload($class)
{
    // クラスファイルの拡張子
    $exts = array(".php");
    // 検索するディレクトリ。
    // [./]や[../]で始めるとNG
    $dirs = array("include/", "");

    foreach($dirs as $dir){
        foreach($exts as $ext){
            $file = LIB_DIR. $dir. $class. $ext;
            if (is_readable($file)) {
                require_once $file;
                return;
            }
           // PEAR形式(
            $file = LIB_DIR. $dir. str_replace("_", "/", $class). $ext;
            if (is_readable($file)) {
                require_once $file;
                return;
            }
        }
    }
    throw new Exception($class."のクラスファイルがありません");
}

/* アクションファイル読み込みチェック */
class Controller
{

    public static $isAjax = false;

    /* Ajaxか否か */
    public static function setAjaxAction()
    {
        self::$isAjax = true;
    }

    /* 遷移 */
    public static function redirect($a, $m='', $t='')
    {
        $root_url = self::get_root_url();

        $url = $root_url;
        if ($m) {
            $url .= $m. "/";
        }
        if ($a) {
            $url .= $a. '.php';
        }
        if ($t) {
            $url .= "?type=". $t;
        }

        header('Location: '. $url);
        exit;
    }

    /* 
     * 自URLを取得
     */
    public static function get_root_url()
    {
        $script_url = self::get_script_url();

        return preg_replace('/\/[-_0-9a-zA-Z]+\.php/', '/', $script_url);
    }
    public static function get_script_url()
    {
        if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') {
            $scheme = 'https://';
        } else {
            $scheme = 'http://';
        }

        $host = $_SERVER['HTTP_HOST'];

        $script_name = $_SERVER['SCRIPT_NAME'];

        return trim($scheme.$host.$script_name);

    }


    /* エラー表示 */
    // toDo: 3で直す
    public static function error_con($msg, $back = false, $close = false, $reload = false)
    {
        if (Controller::$isAjax === true) {
            // エラー内容をシステムログに書込み
            write_syslog($msg);
            exit;
        }

        error($msg, $back, $close, $reload);
    }

    /* Debugger:checkArray */
    public static function dump2error_log($data, $prefix='')
    {
        if (is_array($data)) {
            foreach($data as $k => $v) {
                self::dump2error_log($v, $prefix." ".$k);
            }
        } else if (is_object($data)) {
            error_log($prefix." ".var_dump($data));
        } else {
            error_log($prefix." ".$data);
        }
    }

}

/* app読込み */
function loading_app($action, $dir='')
{
    $file = $action. '.php';
    if ($dir) {
       $file = $dir. '/'. $file;
    }
    $path = APP_DIR. $file;

    if (is_file($path)) {
        return $path;
    } else {
        return false;
    }
}

