<?php
/*
 Ajax Chat for TRPG ver.2.7
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*
 * カード追加用post処理
 */

class PostToCard
{

    private $single_data = array();
    private $add_deckset;
    private $error;

    /* データチェック */
    private function check_card_data($arr)
    {
        // カード名
        if (!$arr['name_long']) {
            $this->set_error('カード名(name_long)がない設定は無効です。');
            return false;
        }
        if (!is_string($arr['name_short'])
             || !is_string($arr['name_long'])
             || !is_string($arr['text'])) {
                    $this->set_error('設定ファイルとして正しくない表記が含まれています。');
            return false;
        }

        return $arr;
    }
    /* 追加カード情報(1枚)を配列にセット */
    public function set_new_card($data, $type = 'add')
    {
        if (!$data['name_short']) {
            $data['name_short'] = mb_substr($data['name_long'], 0, 4);
        }

        $add_deckset = array();
        foreach ($data as $k => $v) {
            switch($k) {
                case 'text':
                    $data = nl2br($v);
                    $add_deckset[$k] = Tw_Obf::obf_xor($data, OBFUSCATION);
                    break;
                case 'name_short':
                case 'name_long':
                    $add_deckset[$k] = Tw_Obf::obf_xor($v, OBFUSCATION);
                    break;
                default:
                    $add_deckset[$k] = $v;
                    break;
            }
        }

        $this->set_add_deckset($add_deckset, $type);
    }


    /* シングルカードPOST */
    public function get_single_data()
    {
        return $this->single_data;
    }
    public function set_post_data2single_data($posts)
    {
        if (!is_array($posts) || empty($posts)) {
            $this->set_error('データがありません。');
            return false;
        }
        $data = array();
        foreach ($posts as $k => $v) {
            switch($k) {
                case 'ns':
                    $data['name_short'] = $v;
                    break;
                case 'nl':
                    $data['name_long'] = $v;
                    break;
                case 'tx':
                    $data['text'] = $v;
                    break;
                default:
                    $data[$k] = $v;
                    break;
            }
        }
        $this->single_data = $data;

        return $this->single_data;
    }
    public function check_post_card_data($posts)
    {
        $data = $this->set_post_data2single_data($posts);

        return $this->check_card_data($data);
    }
    public function set_new_card4post($data, $type = 'add')
    {
        return $this->set_new_card($data, $type);
    }

    /* デックPOST */
    /* データをチェックしてカード設定iniに変換 */
    public function set_inidata2card($data)
    {
        $result = $this->check_is_card_ini($data);

        if (!$result['card_ini']) {
            $result['error'] = 'カード設定が含まれていません';
        }

        return $result;
    }
    public function check_is_card_ini($data) {
//    Controller::dump2error_log($data);

        $result = array();
        $card_ini = parse_ini_string($parse_ini_string, true);

        if (!is_array($card_ini) || !$card_ini) {
            throw new Return_Exception('設定ファイルではありません。');
        }

        foreach ($card_ini as $k => $v) {
            // config設定は一部変更
            if ($k == 'config') {
                $config = array();
                if ($v['name']) {
                    $config['name'] = $v['name'];
                } else {
                    $config['name'] = USER_DECK_NAME;
                }
                if ($v['bg_image']) {
                    $config['bg_image'] = $v['bg_image'];
                }
                if ($v['bg_color']) {
                    $config['bg_color'] = $v['bg_color'];
                }
                if ($v['text_color']) {
                    $config['text_color'] = $v['text_color'];
                }
                if ($v['text_prefix']) {
                    $config['text_prefix'] = $v['text_prefix'];
                }
                if ($v['text_postfix']) {
                    $config['text_postfix'] = $v['text_postfix'];
                }
                if (isset($v['is_head'])) {
                    $config['is_head'] = $v['is_head'];
                }

                $result['card_ini'][$k] = $config;
                continue;
            } else {
                $is_card = $this->check_card_data($v);

                if ($is_card) {
                    $result['card_ini'][$k] = $v;
                }
            }
        }

        return $result;
    }


    /* 追加デックセット */
    public function get_add_deckset()
    {
        return $this->add_deckset;
    }
    protected function set_add_deckset($data, $type = 'add')
    {
        $this->add_deckset[$type][] = $data;

        return $this->add_deckset;
    }

    /* エラー */
    public function get_error()
    {
        $this->get_error;
    }
    protected function set_error($msg)
    {
        $this->error .= $msg;
    }

}
