<?php
/*
 Ajax Chat for TRPG ver.2.7
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*
 * ファイル処理
 */

class Tw_Filer
{

    private $isLocked = false;
    private $lfp;

    /* ファイル読込み */
    public function fileRead($file, $str, $mode='w', $type='reload')
    {
        if ($mode != 'w' && $mode != 'a') {
            $this->throwException4filelock('fopen mode ('.$mode.') の指定が不正です', 'reload');
        } else {
            if (!$fp = @fopen($file, $mode)) {
                $this->throwException4filelock('ファイルが開けません', $type);
            }
            fwrite($fp, $str);
            fclose($fp);
        }
    }

    /* ファイル書込み */
    public function fileWrite($file, $str, $mode='w', $type='reload')
    {
        if ($mode != 'w' && $mode != 'a') {
            $this->throwException4filelock('fopen mode ('.$mode.') の指定が不正です', 'reload');
        } else {
            if (!$fp = @fopen($file, $mode)) {
                $this->throwException4filelock('ファイルが開けません', $type);
            }
            fwrite($fp, $str);
            fclose($fp);
        }
    }

    /* ファイルロック */
    public function fileLock($lockfile)
    {
        $lfp = fopen($lockfile, "w");
        if ($lfp === false) {
            throw new Return_Exception('ファイルロックに失敗しました');
        }
        stream_set_write_buffer($lfp, 0);
        flock($lfp, LOCK_EX);

        $this->isLocked = true;

        return $lfp;
    }
    public function fileUnlock($lfp)
    {
        $this->isLocked = false;

        fflush($lfp);
        fclose($lfp);
    }
    /* ファイルロック状態を判断してthrow Exception */
    protected function throwException4filelock($msg, $type)
    {
        // ロック解除
        if ($this->isLocked === true) {
            Controller::fileUnlock($lfp);
        }

        switch ($type) {
            case 'return':
                throw new Return_Exception($msg);
                break;
            case 'close':
                throw new CloseWindow_Exception($msg);
                break;
            case 'reload':
                throw new Reload_Exception($msg);
                break;
            default:
                throw new Exception($msg);
                break;
        }
    }

    /* setter/getter */
    private function set_isLocked($value)
    {
        $this->isLocked = (bool)$value;
    }
    public function get_isLocked()
    {
        return $this->isLocked;
    }
    private function set_lfp($lfp)
    {
        $this->lfp = $lfp;
    }
    public function get_lfp()
    {
        return $this->lfp;
    }

}

