<?php
/*
 Ajax Chat for TRPG ver.2.7
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*
 * iniファイル処理
 */

/*
 * ytk様の以下のソースをベースとしております。
 * http://wiki.hinami.net/?ykt%2Fprogram%2Fphp%2Fsave_ini_file
 */

class Tw_IniFiler extends Tw_Filer
{

    private $string;
    private $section_prefix_number = 0;

    /* ini形式のファイルを保存
     * $file_path : string, 出力ファイルパス
     * $source : array, parse_ini_file/parse_ini_stringで生成した連想配列形式
     * $section_name_prefix : 設定すると、セクション名が $section_name_prefix_連番 になる。設定が無い場合のセクション名は $sourceのkey
     * $file_overwrite : 出力ファイルが既存の場合、trueで上書き、falseでエラー停止
     * $process_sectionsはTRUE固定
     * $scanner_modeはINI_SCANNER_NORMAL（オプション値パースせず)固定
     * 
     * 返り値: $file_pathに成功:書き込んだバイト数、失敗:false
     */
    public function save_ini_file($file_path, $source, $section_name_prefix='', $file_overwrite=false)
    {
        // 出力ファイル存在チェック
        if ($file_overwrite && file_exists($file_path)) {
            $this->throwException4filelock("Not overwritten. ".$file_path, 'return');
        }

        $this->get_ini_filetext($source, $section_name_prefix);

        if (!$this->string) {
            $this->throwException4filelock("No Ini Data.", 'return');
        }

        return file_put_contents($file_path, $this->string, LOCK_EX);
    }
    
    /* ini形式のファイル内容を作成
     */
    public function get_ini_filetext($source, $section_name_prefix='')
    {
        // ini配列を文字列に展開
        if (!is_array($source) || !$source) {
            throw new Return_Exception("source was invalid.");
        }

        foreach($source as $key => $value) {
            $this->string .= $this->set_section_name($key, $section_name_prefix) . "\n";

            // $valueが配列か否か
            if (is_array($value)) {
                // セクションの記述を保持する
                $this->string .= $this->save_ini_file_parseSection($value) . "\n";
            } else {
                $this->string .= $key . '=' . $this->save_ini_file_format($value) . "\n";
            }
        }
    }

    private function save_ini_file_parseSection($array)
{
        $string = '';
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                $string .= $key . $this->save_ini_file_parseArrayData($value);
            } else {
                $string .= $key . '=' . $this->save_ini_file_format($value) . "\n";
            }
        }
        return $string;
    }

    private function save_ini_file_parseArrayData($array)
    {
        $string = '';
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                $string .= $key . $this->save_ini_file_parseArrayData($value) . "\n";
            } else {
                return '[' . $key . ']=' . $this->save_ini_file_format($value);
            }
        }
        return $string;
    }

    private function save_ini_file_format($value)
    {
        if (is_numeric($value)) {
            return $value;
        } else {
            return '"' . $value . '"';
        }
    }

    // セクション名を設定
    public function set_section_name($section_name, $section_name_prefix='')
    {
        // $section_name_prefixがある場合、section_name変更
        if ($section_name != 'config' && $section_name_prefix) {
            $i = $this->get_section_prefix_number();
            $section_name = $section_name_prefix."_".intval($i);

            $this->set_section_prefix_number($i+1);
        }

        return '[' . $section_name . ']';
    }

    /*
     * セクション名自動設定
    */
    protected function set_section_prefix_number($i)
    {
        $this->_section_prefix_number = $i;
    }
    public function get_section_prefix_number()
    {
        return $this->_section_prefix_number;
    }
}

