<?php
/*
 Ajax Chat for TRPG ver.2.7
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*
 * 送信データ
 */

class Tw_Post
{

    private $posts;

    private $file;
    private $up_error;
    private $upfile_data;

    public function Tw_Post()
    {
        $this->set_file();
        $this->set_posts();

        return $this;
    }

    /* 各種処理 */
    /* エンティティ処理 */
    public function convert($posts)
    {
        $data = '';
        if (is_array($posts)) {
            foreach($posts as $k => $v) {
                $data[$k] = htmlspecialchars($v);
            }
        } else {
            $data = $posts;
        }

        return $data;
    }
    /* 改行 */
    public static function convertCr($str)
    {
        if (strpos($str, "\r") !== false || strpos($str, "\n") !== false) {
            $str = "<br />". $str;
        }
        $str = nl2br($str);
        $str = str_replace(array("\r\n","\r","\n"), '', $str);
        return $str;
    }


    /* 実施者チェック */
    public function check_dealer()
    {
        if (!$this->posts['n']) {
            throw new CloseWindow_Exception('送信情報が不正です');
        }
    }

    /* $_FILE */
    public function get_file()
    {
        return $this->file;
    }
    private function set_file()
    {
        if ($_FILES) {
            $this->file = $_FILES;
        }

        $this->set_uploadfile();
        return $this->file;
    }

    /* アップロードファイルの内容 */
    public function get_uploadfile()
    {
        return $this->upfile_data;
    }
    public function get_up_error()
    {
        return $this->up_error;
    }
    /* チェックして読み込み */
    public function set_uploadfile() {
        // アップロードされたファイルをチェック
        $this->up_error = $this->check_uploadfile();

        if (!$this->up_error) {
            $this->upfile_data = file_get_contents($this->file['file']['tmp_name']);
            @unlink($this->file['file']['tmp_name']);
        }
    }
    public function check_uploadfile()
    {
        switch($this->file['file']['up_error']) {
            case '0':
                if (!is_uploaded_file($this->file['file']['tmp_name'])) {
                    return '不正なファイルです。';
                } else {
                    return null;
                }
                break;
            case '1':
                return 'ファイルがサーバの設定サイズを超えています。';
                break;
            case '2':
                return 'ファイルのサイズが大きすぎます。';
                break;
            case '3':
            case '4':
                return 'アップロードされませんでした。';
                break;
            case '6':
            case '7':
            case '8':
                return 'アップロードに失敗しました。サーバの設定を確認してください。';
                break;
            default:
                return '原因不明のエラーです。';
                break;

        }
    }

    /* $_POST */
    public function get_posts()
    {
        return $this->posts;
    }
    private function set_posts()
    {
        if ($_GET) {
            return $this->posts = $this->convert($_GET);
        } elseif ($_POST) {
            return $this->posts = $this->convert($_POST);
        } elseif ($_REQUEST) {
            return $this->posts = $this->convert($_REQUEST);
        } else {
            return $this->posts = array();
        }
    }


    public static function &getInstance()
    {
        static $singleton;
        if (empty($singleton)) {
            $singleton = new Tw_Post();
        }
        return $singleton;
    }

}
