<?php
class UsersController extends ModuleController {

	var $name = 'Users';
	var $helpers = array(
		'Html',
		'Form',
		'Token'
	);

	/* ACL */
	// 追加アクション用 crudMap
	var $actionMapPlus = array(
		'listview' => 'read',
		'change_password' => 'update',
	);

	var $disableTokenActions = array('add','mobile_add');

	function beforeFilter() {

		parent::beforeFilter();

		// 不正fieldsのPOST削除(id, createdなど）
		$this->unsetData('auto', true);

		// 認証なしアクセス可
		$this->AuthPlus->allow('login');
		$this->AuthPlus->allow('add'); //todo:メール認証etc
		$this->AuthPlus->allow('logout');
		$this->AuthPlus->allow('to_login');
		$this->AuthPlus->allow('mobile_login');
		$this->AuthPlus->allow('mobile_add'); //todo:メール認証etc
		$this->AuthPlus->allow('mobile_logout');
		$this->AuthPlus->allow('mobile_to_login');

	}

	/* PC */
	function login() {
		// 現在のセッション削除
		$this->AuthPlus->deleteAuth();
	}

	function logout() {
		self::_logout();
	}

	function to_login($refresh = 3)
	{
		// 現在のセッション削除
		$this->AuthPlus->logout();

		$this->set('refresh', array('time' => $refresh, 'url' => Router::url('index', false)));
	}

	function index() {
		self::_index();
	}

	function view($id = null) {
		self::_view($id);
	}

	function listview() {

		self::_listview();
	}

	function add() {
		if (!empty($this->data)) {
			self::_add();
		}

		$this->set('idLength', Configure::read('User.UserId.Length'));
		$this->set('passwordLength', Configure::read('User.Password.Length'));
	}

	function edit($id = null) {
		self::_edit($id);
	}

	function change_password($id = null) {
		self::_change_password($id);

		$this->set('passwordLength', Configure::read('User.Password.Length'));
	}

	function delete($id = null) {
		self::_delete($id);
	}

	/* 携帯側 */
	function mobile_login() {
		// 現在のセッション削除
		$this->AuthPlus->deleteAuth();
	}

	function mobile_logout() {
		self::_logout();
	}
	
	function mobile_index() {
		self::_index();
	}
	function mobile_view($id = null) {
		self::_view($id);
	}

	function mobile_listview() {

		self::_listview();
	}

	function mobile_add() {
		if (!empty($this->data)) {
			self::_add();
		}

		$this->set('idLength', Configure::read('User.UserId.Length'));
		$this->set('passwordLength', Configure::read('User.Password.Length'));
	}

	function mobile_edit($id = null) {
		self::_edit($id);
	}

	function mobile_change_password($id = null) {
		self::_change_password($id);

		$this->set('passwordLength', Configure::read('User.Password.Length'));
	}

	function mobile_delete($id = null) {
		self::_delete($id);
	}

	/* 管理画面 */
	function admin_index() {
		$this->redirect(array('controller' => 'users', 'action'=>'listview'));
	}

	function admin_listview() {

		// 検索処理
		$this->User->contain();
		$contain = array();
		$searchword = array();
		if (!empty($this->data)) {
			if (isset($this->data['User']['name'])) {
				$name = $this->data['User']['name'];
			}
		} else {
			if (isset($this->passedArgs['name'])) {
				$name = urldecode($this->passedArgs['name']);
			}
		}


		if (isset($name)) {
			$this->data['User']['name'] = $name;
			$contain["User.name LIKE"] = "%".Sanitize::html($name)."%";
			$searchword['name'] = urlencode($name);
		}
		$this->set('searchword', $searchword);

		$this->set('users', $this->paginate('User', $contain));

	}

	function admin_view($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid User.', true));
			$this->redirect(array('controller' => 'users', 'action'=>'index'));
		}
		$this->set('user', $this->User->read(null, $id));
	}

	function admin_add() {
		if (!empty($this->data)) {
			self::_add(true);
		}

		$this->set('idLength', Configure::read('User.UserId.Length'));
		$this->set('passwordLength', Configure::read('User.Password.Length'));
	}

	function admin_change_password($id = null) {

		if (!$id && empty($this->data)) {
			$this->Session->setFlash(__('No ID', true));
			$this->redirect(array('controller' => 'users', 'action'=>'index'));
		}
		if (!empty($this->data)) {
			$result = self::_exe_change_password($id);
			if ($result) {
				$this->Session->setFlash(__('The password has been changed.', true));
				$this->redirect(array('controller' => 'users', 'action'=>'index'));
			}
		}
		if (empty($this->data)) {
			$this->data = $this->User->read(null, $id);
		}

		$this->set('passwordLength', Configure::read('User.Password.Length'));
	}

	function admin_delete($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('No ID', true));
			$this->redirect(array('controller' => 'users', 'action'=>'index'));
		}
		if ($this->data) {
			$result = self::_exe_delete($id);
			if ($result) {
				$this->redirect(array('controller' => 'users', 'action'=>'index'));
			}
		}

		$user = self::getUser($id);
		if (!$user) {
			$this->Session->setFlash(__('No Member', true));
			$this->redirect(array('controller' => 'users', 'action'=>'listview'));
		}
		$this->set('user', $user);

		$this->data['User']['id'] = $id;
	}

	/* Users共通メソッド */
	function _logout() {
		$this->Session->setFlash(__('Logout.', true));
		$this->redirect($this->AuthPlus->logout());
	}

	function _index() {
		// アクセス更新
		$this->User->id = $this->AuthPlus->user('id');
		$this->User->saveField('useragent', $_SERVER["HTTP_USER_AGENT"]);
		$this->User->saveField('host', gethostbyaddr($_SERVER["REMOTE_ADDR"]));

		$this->set('user', $this->User->read(null, $this->AuthPlus->user('id')));
	}

	function _view($id) {
		if ($id && $id == $this->AuthPlus->user("id")) {
			$this->redirect(array('action'=>'index'));
		}

		$user = self::getUser($id);
		if (!$user) {
			$this->redirect(array('action'=>'listview'));
		}
		$this->set('user', $user);
	}

	function _listview() {
		$this->User->recursive = -1;
		$this->set('users', $this->paginate());
	}

	function _add() {
		$this->unsetData('add', false);
		if (!$this->isAdmin) {
			unset($this->data['User']['group_id']);
		}
		// バリデーション
		$this->User->set($this->data);
		if ($this->User->validates()) {

			// ACL設定（デフォルト：一般ユーザ）
			if (!isset($this->data['User']['group_id'])) {
				$this->data['User']['group_id'] = Configure::read('Group.member');
			}

			// passwordセット
			$this->data['User']['password'] = $this->AuthPlus->password($this->data['User']['password1']);

			// 他データ
			if (!$this->isAdmin) {
				$this->data['User']['useragent'] = $_SERVER["HTTP_USER_AGENT"];
				$this->data['User']['host'] = gethostbyaddr($_SERVER["REMOTE_ADDR"]);
			}

			// save
			$this->User->create();
			if ($this->User->save($this->data)) {
				$this->Session->setFlash(__('The User has been saved', true));
				if (!$this->isAdmin) {
					$this->redirect($this->AuthPlus->logoutRedirect);
				} else {
					$this->redirect(array('controller' => 'users', 'action'=>'listview'));
				}
			} else {
				$this->Session->setFlash(__('The User cannot be saved.', true));
			}
		}
	}

	function _edit($id) {
		if (!$id && empty($this->data)) {
			$this->Session->setFlash(__('Invalid User', true));
			$this->redirect(array('action'=>'index'));
		}
		if ($id != $this->AuthPlus->user("id")) {
			$this->Session->setFlash(__('No permission.', true));
			$this->redirect(array('action'=>'index'));
		}
		if (!empty($this->data)) {
			// ユーザ変更以外のPost削除
			$this->unsetData('edit', false);

			if ($this->User->save($this->data)) {
				$this->Session->setFlash(__('The User has been saved', true));
				$this->redirect(array('action'=>'index'));
			} else {
				$this->Session->setFlash(__('The User could not be saved. Please, try again.', true));
			}
		}
		if (empty($this->data)) {
			$this->data = $this->User->read(null, $id);

			$this->data['User']['name'] = $this->User->restore_html($this->data['User']['name'], false);
		}
	}

	function _change_password($id) {
		if (!$id && empty($this->data)) {
			$this->Session->setFlash(__('No ID', true));
			$this->redirect(array('action'=>'index'));
		}
		if ($id != $this->AuthPlus->user("id")) {
			$this->Session->setFlash(__('No permission.', true));
			$this->redirect(array('action'=>'index'));
		}
		if (!empty($this->data)) {
			// password以外のPost削除
			$this->unsetData('*', '', 'password');

			$data = $this->User->read('password', $id);
			if ($data['User']['password'] != $this->AuthPlus->password($this->data['User']['password'])) {
				$this->Session->setFlash(__('Old Password is wrong.', true));
			} else {
				$result = self::_exe_change_password($id);
				if ($result) {
					$this->Session->setFlash(__('The password has been changed. Please login at new password.', true));
					$this->redirect($this->AuthPlus->logout());
				}
			}
		}

		$this->data['User']['id'] = $id;
	}
	function _exe_change_password($id) {
		// バリデーション
		$this->User->set($this->data);
		if ($this->User->validates()) {

			// passwordセット
			$this->data[$this->AuthPlus->userModel]['password'] = $this->AuthPlus->password($this->data[$this->AuthPlus->userModel]['password1']);

			if ($this->User->save($this->data)) {
				return true;
			} else {
				$this->Session->setFlash(__('The User could not be saved. Please, try again.', true));
				return false;
			}
		}
	}

	function _delete($id) {
		if (!$id) {
			$this->Session->setFlash(__('No ID', true));
			$this->redirect(array('action'=>'index'));
		}
		if ($id != $this->AuthPlus->user("id")) {
			$this->Session->setFlash(__('Permission denied.', true));
			$this->redirect(array('action'=>'index'));
		}
		if ($this->data) {
			$data = $this->User->read('password', $id);
			if ($data['User']['password'] != $this->AuthPlus->password($this->data['User']['password'])) {
				$this->Session->setFlash(__('Password is wrong.', true));
			} else {
				$result = self::_exe_delete($id);
				if ($result) {
					$this->redirect($this->AuthPlus->logout());
				} else {
					$this->redirect(array('action'=>'index'));
				}
			}
		}
		$this->data['User']['id'] = $id;
	}
	function _exe_delete($id) {
		$user = self::getUser($id);
		if (!$user) {
			return false;
		}
		if ($user['User']['group_id'] == 1) {
			$this->Session->setFlash(__('Super Administrator can not be deleted.', true));
			return false;
		}
		if ($this->User->del($id)) {
			$this->Session->setFlash(sprintf(__('%s was deleted.', true), $user['User']['name']));
			return true;
		} else {
			$this->Session->setFlash(__('The account could not be deleted.', true));
			return false;
		}
	}

	function getUser($id) {
		if (!$id) {
			$this->Session->setFlash(__('Error, No id.', true));
			return null;
		}
		$user = $this->User->read(null, $id);
		if (!$user['User']) {
			$this->Session->setFlash(__('Invalid User.', true));
			return null;
		}
		return $user;
	}

}
