<?php

app::import('Sanitize');

class AppModel extends Model {
	var $actsAs = array(
		'Cakeplus.ValidationErrorI18n',
		'Cakeplus.AddValidationRule',
		'SanitizePlus',
	);

	/* 
	 * DBフィールドごとの基本処理設定
	 * 例
	 * var $fields = array(
	 *	'field_name' => array( // field名
	 *		'auto' => false, // true:自動設定値 ユーザ設定不可(id, created, modified...)
	 *		'add' => true, // true: 追加画面でフォームを表示する項目
	 *		'edit' => false, // 編集画面でフォーム表示を表示する項目
	 *		'escape' => array( // escape処理
	 *			'html' => true, // true: Sanitize::html()を行なう
	 *			'all' => true, // true: Sanitize::stripAll()を行なう
	 *			'whitespace' => true, // true: Sanitize::stripWhitespace()を行なう
	 *			'images' => true, // true: Sanitize::stripImages()を行なう
	 *			'sctipts' => true, // true: Sanitize::stripScripts()を行なう
	 *		),
	 *	),
	 * $fields設定は個々のモデルで行なう
	*/
	var $fields = array();

	/* コールバックメソッド */
	function beforeValidate($options = array())
	{
		// i18n Error Messages
		// Working on the CakePlus
		$error_messages = array(
			'notEmpty' 	=> __('Please be sure to input.', true),
			'between' => __('Between %2$d and %3$d characters.', true),
			'minLength' => __('More than %2$d characters.', true),
			'maxLength' => __('Less than %2$d characters.', true),
			'alphaNumeric' => __('Please input only alphameric characters.', true),
			'compare2fields' => __('Please input same as above.', true),
			'betweenWrapper' => __('Too short or Too long.', true),
			'isUnique' => __('It was already registed.', true),
		);
		$this->setErrorMessageI18n($error_messages, false);

		$this->replaceValidationErrorMessagesI18n();

		return parent::beforeValidate($options);
	}

	function beforeSave($options = array())
	{
		// Sanitize(不正コード、SQL Injection)
		$this->data = Sanitize::clean(
			$this->data,
			array(
				'encode' => false,
			)
		);

		return parent::beforeSave($options);
	}

	/* Validation */
	/* alphaNumeric() */
	/** It Overwrites the original alphaNumeric() **/
	function alphaNumeric($data)
	{
		$check = is_array($data) ? array_shift($data) : $data;
		if (preg_match('/^[0-9a-z]+$/i',$check)) {
			return true;
		} else {
			return false;
		}
	}

	/* Wrapper to the origibal between() */
	function betweenWrapper($check, $min, $max)
	{
		return Validation::between($check, $min, $max);
	}

}
