<?php

/* 
 * 独自のSanitize、逆Sanitizeの追加Behavoir
 * The behavoir of the additional Sanitize rules, reverse-Sanitize rules.
 */

app::import('Sanitize');

class SanitizePlusBehavior extends ModelBehavior {

	var $settings = array();

	function setup(&$model, $config = array()) {
		$this->settings = $config;
	}

	/* 各modelに設定した$fieldsの設定でSanitize */
	// Sanitize::clean(),Sanitize::escape()以外
	function escapeByFields(&$model, $field, $string)
	{
		if (isset($model->fields[$field]['escape']['all']) && $model->fields[$field]['escape']['all']) {
			$string = Sanitize::stripAll($string);
		} else {
			if (isset($model->fields[$field]['escape']['whitespace']) && $model->fields[$field]['escape']['whitespace']) {
				$string = Sanitize::stripWhitespace($string);
			}
			if (isset($model->fields[$field]['escape']['images']) && $model->fields[$field]['escape']['images']) {
				$string = Sanitize::stripImages($string);
			}
			if (isset($model->fields[$field]['escape']['sctipts']) && $model->fields[$field]['escape']['sctipts']) {
			$string = Sanitize::stripScripts($string);
			}
		}
		if (isset($model->fields[$field]['escape']['html']) && $model->fields[$field]['escape']['html']) {
			$string = Sanitize::html($string);
		}
		return $string;
	}

	/* reverse-Sanitize */
	/* return HTML tags from HTML entities.
	 * base on ver1.2.5
	 * @param string $string Sanitized Data
	 * @param boolean $strip_all If true, Sanitized by Sanitize::stripAll(), and NO NEEW to set below 3 $args.
	 * @param boolean $strip_scripts If true, Sanitized by Sanitize::stripScripts()
	 * @param boolean $strip_images If true, Sanitized by Sanitize::stripImages()
	 * @param boolean $strip_whitespace If true, Sanitized by Sanitize::stripWhitespace()
	 * return Data reverted HTML tags
	 */
	function restore_html(&$model, $string, $strip_all = true, $strip_scripts = true, $strip_images = true, $strip_whitespace = true) {
		$patterns = array("/\&amp;/", "/\&#37;/", "/\&lt;/", "/\&gt;/", "/\&quot;/", "/\&#39;/", "/\&#40;/", "/\&#41;/", "/\&#43;/", "/\&#45;/");
		$replacements = array("&", "%", "<", ">", '"', "'", "(", ")", "+", "-");

		$string = preg_replace($patterns, $replacements, $string);

		if ($strip_all) {
			$string = Sanitize::stripAll($string);
		} else {
			if ($strip_scripts) {
				$string = Sanitize::stripScripts($string);
			}
			if ($strip_images) {
				$string = Sanitize::stripImages($string);
			}
			if ($strip_whitespace) {
				$string = Sanitize::stripImages($string);
			}
		}

		return $string;
	}

	/* return SQL descaped strings.
	 */
	function restore_escape(&$model, $string) {

		return stripslashes($string);
	}

}
