<div class="notes index">
<h2><?php __('Notes');?> for Mobile</h2>
<p>
<?php
echo $paginator->counter(array(
'format' => __('Page %page% of %pages%, showing %current% records out of %count% total, starting on record %start%, ending on %end%', true)
));
?></p>
<table cellpadding="0" cellspacing="0">
<tr>
	<th><?php echo $paginator->sort('id');?></th>
	<th><?php echo $paginator->sort('member_id');?></th>
	<th><?php echo $paginator->sort('lat');?></th>
	<th><?php echo $paginator->sort('lon');?></th>
	<th><?php echo $paginator->sort('title');?></th>
	<th><?php echo $paginator->sort('body');?></th>
	<th><?php echo $paginator->sort('public_flag');?></th>
	<th><?php echo $paginator->sort('created');?></th>
	<th><?php echo $paginator->sort('modified');?></th>
	<th class="actions"><?php __('Actions');?></th>
</tr>
<?php
$i = 0;
foreach ($notes as $note):
	$class = null;
	if ($i++ % 2 == 0) {
		$class = ' class="altrow"';
	}
?>
	<tr<?php echo $class;?>>
		<td>
			<?php echo $note['Note']['id']; ?>
		</td>
		<td>
			<?php echo $html->link($note['Member']['id'], array('controller' => 'members', 'action' => 'mobile_view', $note['Member']['id'])); ?>
		</td>
		<td>
			<?php echo $note['Note']['lat']; ?>
		</td>
		<td>
			<?php echo $note['Note']['lon']; ?>
		</td>
		<td>
			<?php echo $note['Note']['title']; ?>
		</td>
		<td>
			<?php echo $note['Note']['body']; ?>
		</td>
		<td>
			<?php echo $note['Note']['public_flag']; ?>
		</td>
		<td>
			<?php echo $note['Note']['created']; ?>
		</td>
		<td>
			<?php echo $note['Note']['modified']; ?>
		</td>
		<td class="actions">
			<?php echo $html->link(__('View', true), array('action' => 'mobile_view', $note['Note']['id'])); ?>
			<?php echo $html->link(__('Edit', true), array('action' => 'mobile_edit', $note['Note']['id'])); ?>
			<?php echo $html->link(__('Delete', true), array('action' => 'mobile_delete', $note['Note']['id']), null, sprintf(__('Are you sure you want to delete # %s?', true), $note['Note']['id'])); ?>
		</td>
	</tr>
<?php endforeach; ?>
</table>
</div>
<div class="paging">
	<?php echo $paginator->prev('<< '.__('previous', true), array(), null, array('class'=>'disabled'));?>
 | 	<?php echo $paginator->numbers();?>
	<?php echo $paginator->next(__('next', true).' >>', array(), null, array('class' => 'disabled'));?>
</div>
<div class="actions">
	<ul>
		<li><?php echo $html->link(__('New Note', true), array('action' => 'mobile_add')); ?></li>
		<li><?php echo $html->link(__('List Members', true), array('controller' => 'members', 'action' => 'mobile_index')); ?> </li>
		<li><?php echo $html->link(__('New Member', true), array('controller' => 'members', 'action' => 'mobile_add')); ?> </li>
	</ul>
</div>
