<?php
/*
 * Ajax Chat for TRPG ver.1.2
 * (c)2007 Cake All righ1ts reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 *
 * [注意事項他]
 * 本チャットスクリプトの使用および配布は、BSDライセンスに基づきます。
 * BSDライセンスの詳細につきましては、添付のライセンス.txtを参照してください。
 *
 * BSDライセンス概要＆使用上の注意
 * 1. このスクリプトはフリーソフトです。以下の条件を満たす限りにおいて、使用・改造・再配布（オリジナルおよび改造版の両方とも）は自由です。
 * 再配布する場合、上記著作権表示、本条件書きおよび第2項・第3項の責任限定規定を必ず含めてください。
 * 2. 同梱のアイコンの大部分は、Petite Prier様(http://snow.if.tv/)の素材です。
      本スクリプトの使用および再配布時にアイコンをそのまま用いる場合は、配布元の規定も遵守してください。
 * 3. 本スクリプトは無保証です。自己責任で使用してください。このスクリプトを使用したいかなる損害に対しても、作者は一切の責任を負いません。
 * 4. 設置および使用方法に関する質問は、配布サイトの掲示板にお願いします。ただし、必ず回答できるとは限りません。
 * メールによる質問は、ご遠慮ください。
 */

// 設定ファイルの読み込み
require_once 'trpgchat-ini.php';

// HTML出力
print html_header('main', $title.' ログ表示画面', true, true);

 ?>

<script type="text/javascript">
<!--

//変数の設定
var getdata_on = <?php print $getdata_on;?>*1000;
var getdata_off = <?php print $getdata_off;?>*1000;
var logfile= '<?php print $recent_log;?>';
var now_member = '<?php print $now_member;?>';
var color_system = '#<?php print $color_system;?>';
var status_color = '#<?php print $status_color; ?>';

// 起動時の処理
$(function()
{
    //ログの取得
    getLog();
    // タイマー
    Timer = setInterval('getLog()', getdata_off);
});

// ログ取得
function getLog(){
    $.ajax({
        type: "GET",
        ifModified: true,
        url: logfile,
        success: function(data){
    // 最新行番号の取得
    if (!isNaN(document.getElementById('id'))) {
        last_id = 0;
    } else {
        last_id = document.getElementById('id').firstChild.nodeValue;
    }

    // ログの整形
        var recent = data.split('\n');

        var text = new Array();
        for(var i=0;i<recent.length; i++){
        // 各行を<>で分割して配列に
            var unit = recent[i].split('<>');

        // データがなければ終了
            // last_idで終点判断
            if(unit[0] && last_id < unit[0]){
                    text[i] = setData(unit);
            } else {
                break;
            }
        }

        var text_rev = text.reverse();

        for(var i=0;i<text_rev.length; i++){
        //出力
            $("#online").after(text_rev[i]);
        }
    }
    });
    // 在室表示
    showMember();
}

// 在室表示
function showMember() {
    $.ajax({
        type: "GET",
        ifModified: true,
        url: now_member,
        success: function(data2){
        // ログの整形
            var member = data2.split('\n');
            var text2 = "";
            var unit2 = new Array();
            for(var i=0;i<member.length; i++){
                var unit2 = member[i].split('<>');
        // データがなければ終了
                if(!unit2[0]){
                    break;
                }
                var text2 = text2+'<span id="'+unit2[0]+'" class="member" onclick="inputWhisper(\''+unit2[0]+'\',\''+unit2[1]+'\')">'+unit2[0]+'</span>'+'<>';
                // my_hashに自分のハッシュ登録
                if (!$(window.parent.document.getElementById("my_hash")).attr("value") && $(window.parent.document.getElementById("pwd_on")).attr("value") && $(window.parent.document.getElementById("name_on")).attr("value")==unit2[0]) {
                    window.parent.document.getElementById("my_hash").value = unit2[1];
                }
            }
    // 出力
            if (text2) {
                $("#indi").html(text2);
            }
        }
    });
}

// ログイン・ログオフ
function login() {
    clearInterval(Timer);
    Timer = setInterval('getLog()', getdata_on);
    $("#help").hide();
    $("#online").show();
    clearLog();
}
function logout() {
    clearInterval(Timer);
    Timer = setInterval('getLog()', getdata_off);
    window.parent.document.getElementById("whisper_mark").src="<?php print $whisper_on; ?>"
    window.location.reload();
}

// 遅延関数(http://zombiebook.seesaa.net/article/26143018.html)
function wait(fn, tm){
    return function (){
        var slf = this, arg = arguments;
        setTimeout(function (){fn.apply(slf, arg);}, tm);
    }
}

// リフレッシュ
function clearLog(){
    $.ajax({
        type: "GET",
        ifModified: false,
        url: logfile,
        success: function(data){
        var recent = data.split('\n');
        var text = new Array();
        $(".com_row").remove();
        for(var i=0;i<recent.length; i++){
            var unit = recent[i].split('<>');
            if (unit[0]) {
                text[i] = setData(unit);
            }
        }
        var text_rev = text.reverse();
        for(var i=0;i<text_rev.length; i++){
        //出力
            if(text_rev[i]){
                $("#online").after(text_rev[i]);
            }
        }
    }
    });
}

// ささやき指定
function inputWhisper(name, whisperTo) {
    var flag = whisperTo ? true : false;
    if (flag==false){
        alert(name+"さんは入室パスワード未入力のため、「ささやき」はできません。");
    } else if (!window.parent.document.getElementById("pwd_on").value){
        alert("パスワードを入力しないと「ささやき」はできません。");
    } else if (name=='全員'){
        alert("「全員」という名前の方に「ささやき」はできません(笑)");
    } else {
        window.parent.document.getElementById("whisper_to").value = name;
        window.parent.document.getElementById("whisper_to_hash").value = whisperTo;
        window.parent.document.getElementById("whisper_mark").src="<?php print $whisper_on; ?>"
    }
}

// ログ行整形
function setData(unit) {
    if (!unit) {
        return false;
    }
    //行番号：最新行
    var last_id_tag = '<span id="id" style="display:none;">'+unit[0]+'</span>';
    //データの整形
    var name = unit[1];
    var pc = unit[2];
    var color = unit[3];
    var com = unit[4];
    var d = new Date();
    d.setTime(unit[5]*1000);
    var year = d.getYear();
    if (year < 2000) { year += 1900;}
    var month = d.getMonth()+1;
    if (month < 10) { month = "0" + month;}
    var day = d.getDate();
    if (day < 10) { day = "0" + day;}
    var hour = d.getHours();
    if (hour < 10) { hour = "0" + hour;}
    var min = d.getMinutes();
    if (min < 10) { min = "0" + min;}
    var sec = d.getSeconds();
    if (sec < 10) { sec = "0" + sec;}
    var datetime = year+'/'+month+'/'+day+' '+hour+':'+min+':'+sec;
    var whisper = 'n';
    if(unit[9] || unit[10]) {
        var whisper = 'y';
        if ($(window.parent.document.getElementById("my_hash")).attr("value") == unit[8]) whisper = 'to';
        if ($(window.parent.document.getElementById("my_hash")).attr("value") == unit[10]) var whisper = 'from'
    }
    if(unit[11] == '1' && unit[12]) {
        var status = unit[12];
    }

    // 行の整形
    if (unit[0]!='0' && whisper!='y') {
        row =
        '<div class="com_row" id="com_row_'+unit[0]+'">'+last_id_tag+'<span style="font-weight:bold; color:'+color+';" id="'+unit[0]+'" title="'+name+'">【'+pc+'】</span>：'+
        '<span class="body" title="'+datetime+'">';
        if (whisper=='to' || whisper=='from') {
            row = row+'<span style="color:'+color_system+';">(';
            if (whisper=='to') row = row+unit[9]+'さんへ';
            if (whisper=='from') row = row+unit[2]+'さんから';
            row = row+'のささやき) </span>';

        }
        row = row+com+'</span>';
        if (status) {
            row = row+' <span style="color:'+status_color+';">('+status+')</span>';
        }
        row = row+'</div>';
    } else {
        row = last_id_tag;
    }
    return row;
}
//-->
</script>
</head>
<body>
<div id="help" class="help" style="display:inline;">
<?php print nl2br($help);?>
<hr>
</div>
<div id="online" class="online" style="display:none;">参加者： <span id="indi"></span></div>

<div align="right" id="pastlog" class="pastlog">
<a href="./pastlog_index.php" target="pastlog">もっと前のログを見る</a></div>

<noscript>
<p><img src="image/blog_jscript.gif" alt="Javascript" width="80" height="15">本チャットは、JavaScript が有効な環境でのみ使用可能です。</p>
</noscript>

<?php
// フッター
print html_footer('');
 ?>