<?php
/*
 * Ajax Chat for TRPG ver.1.3
 * (c)2007 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*****************
 *  PHPライブラリ：共通
 *****************/

/* リクエストを取得 */
function request() {
    if (!strcasecmp(METHOD, 'GET')) {
        $request = $_GET;
    } elseif (!strcasecmp(METHOD, 'POST')) {
        $request = $_POST;
    }
    return $request;
}

/* 色選択出力 */
function colorbox($color_code, $id, $select=''){
    $color_list = array();
    foreach ($color_code as $k1 => $v1) {
        foreach ($color_code as $v2) {
            foreach ($color_code as $v3) {
                $color_list[] = $v1.$v2.$v3;
            }
        }
    }
    array_unique($color_list);
    sort($color_list);

    foreach ($color_list as $k => $v) {
        print'<option value="'.$v.'" style="color: #'.$v.'; font-weight:bold;" id="'.$id.'_'.$v.'"';
        if ($select == $v) { print ' selected';}
        print ' >#'.$v.'</option>'."\n";
    }
}

/* ヘッター */
function html_header($title, $window = false, $js = true, $no_cache = true) {
    $header = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">'."\n";
    $header .= '<html>'."\n";
    $header .= '<head>'."\n";
    $header .= '<meta http-equiv="Content-Type" content="text/html; charset=utf-8">'."\n";
    $header .= '<meta http-equiv="Content-Style-Type" content="text/css" />'."\n";
    if ($js) {
        $header .= '<meta http-equiv="Content-Script-Type" content="text/javascript" />'."\n";
    }
    if ($no_cache) {
        $header .= '<meta http-equiv="Pragma" content="no-cache">'."\n";
        $header .= '<meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">'."\n";
        $header .= '<meta http-equiv="Expires" content="Thu, 01 Feb 2007 00:00:00 GMT">'."\n";
    }
    if ($window == 'pastlog') {
        $header .= '<link rel="stylesheet" type="text/css" href="../css/trpgchat.css">'."\n";
    } else {
        $header .= '<link rel="stylesheet" type="text/css" href="./css/trpgchat.css">'."\n";
    }
    if ($window == 'index') {
        $header .= '<link rel="stylesheet" type="text/css" href="./css/index.css">'."\n";
    } elseif ($window == 'main') {
        $header .= '<link rel="stylesheet" type="text/css" href="./css/main.css">'."\n";
    } elseif ($window == 'pastlog') {
        $header .= '<link rel="stylesheet" type="text/css" href="../css/main.css">'."\n";
    }
    $header .= '<title>'.$title.'</title>'."\n";
    if ($js) {
        $header .= '<script type="text/javascript" src="./lib/js/jquery.js"></script>'."\n";
    }

    return $header;
}

/* フッター */
function html_footer($copyright = 'true') {
    if ($copyright) $footer = '<p class="copyright">'.COPYRIGHT.'</p>'."\n";
    $footer .= '</body>'."\n";
    $footer .= '</html>'."\n";

    return $footer;
}

/* エラー表示 */
function error($msg) {
    print html_header('エラー', false, false, false);
    print "</head>\n";
    print "<body>\n";
    print '<font color="red">エラー</font><br>'."\n";
    print $msg."\n";
    print  html_footer('');
    exit;
}

/* トリップ生成 */
function create_hash($name,$pwd) {
    //パスワードがなければ中止
    if (!$pwd) {
        return false;
    }
    $key = substr(substr($pwd,1,2)."dummy",0,2);
    $key = strtr($key,':;<=>?@[\]^_`','ABCDEFGabcdef');
    $pwd = substr(crypt($name, $key), -10);

    return $pwd;
}
?>