<?php
/*
 * Ajax Chat for TRPG ver.1.3
 * (c)2007 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/pastlog.php';

// 受信データの成形
if (!$request = request()) {
    error('リクエストを受信できません');
}

// パスワードの照合
auth();


if (!$request['dirname']) {
    error('ディレクトリ名を入力してください。');
}

if ($request['type'] != $master_past_dir && $request['type'] != $past_dir) {
    error('リクエストが不正です。');
}

// ディレクトリ作成
if ($request['mode'] == '新規作成') {

    // ディレクトリ名チェック
    check_name($request['dirname']);

    if (file_exists($request['type'].$request['dirname'])) {
        error('同じ名前のディレクトリが存在します');
    } else {
        if (!mkdir ($request['type'].$request['dirname'])) {
            error('ディレクトリの作成に失敗しました');
        }
        chmod($request['type'].$request['dirname'], 0707);
        @touch($request['type'].$request['dirname']."/index.html");
        display_finish(TITLE.' 過去ログディレクトリ新規作成', $request['dirname']."を作成しました");
    }
    exit;

// ディレクトリ編集
} elseif ($request['mode'] == '変更') {

    if (!$request['dirname_new']) {
        error('変更後ディレクトリ名を指定してください。');
    }

    // ディレクトリ名チェック
    check_name($request['dirname_new']);

    // 変更
    if (file_exists($request['type'].$request['dirname_new'])) {
        error('同じ名前のディレクトリが存在します');
    }

    if (!rename($request['type'].$request['dirname'], $request['type'].$request['dirname_new'])) {
        error('ディレクトリ名の変更に失敗しました');
    }
    display_finish(TITLE.' 過去ログディレクトリ名変更', $request['dirname']."を".$request['dirname_new']."に変更しました");
    exit;

// ディレクトリ削除
} elseif ($request['mode'] == '削除') {

    if (!file_exists($request['type'].$request['dirname'])) {
        error('指定のディレクトリが存在しません');
    }

    $list = get_dir_contents_list($request['type'].$request['dirname']."/", 'ASC');
    if (count($list['files']) > 0) {
        error('削除したいディレクトリの中のファイルを、全て移動または削除してください');
    }

    // 削除
    @unlink($request['type'].$request['dirname'].'/index.html');
    if(!rmdir($request['type'].$request['dirname'])) {
        error('ディレクトリ削除に失敗しました');
    }

    // 完了表示
    display_finish(TITLE.' 過去ログディレクトリ削除完了', $request['dirname']."を削除しました");

} else {
    error('アクションが不正です');
}

?>