<?php
/*
 * Ajax Chat for TRPG ver.2.0
 * (c)2007-2008 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';

// 設定セット
set_config(read_config());

// アクセスブロック
access_block();

// HTML出力
print html_header(CHAT_TITLE, 'index', true, true);

// JavaScript読み込み
require_once './lib/js/trpgchat-js.php';
require_once './lib/js/index-js.php';

// クッキーの読み込み
$cookies_value = explode("&", $_COOKIE[COOKIE]);
if($cookies_value) {
    foreach($cookies_value as $v) {
        $c_tmp = explode("=", $v);
        $cookies[$c_tmp[0]] = $c_tmp[1];
    }
}
 ?>
<script type="text/javascript">
<!--

//変数の設定
var noname = '<?php print NONAME; ?>';
var writescript = './write.php';
var now_member = '<?php print NOW_MEMBER; ?>';
var pc_num = '<?php print PC_NUM; ?>';
var pc_show = '<?php print PC_SHOW_ICON; ?>';
var pc_hide = '<?php print PC_HIDE_ICON; ?>';

// 起動時の処理
$(function(){
    // 表示系
    // フォームON/OFF
    $("#online1").hide();
    $("#online2").hide();
    document.getElementById("name_on").disabled = true;
    document.getElementById("pwd_on").disabled = true;
    document.getElementById("whisper_to").disabled = true;

    // ログイン
    $("#login").click(function(){

        //入力チェック
        var name = $("#name_off").attr("value");
        if (!name || name == noname) {
            alert("お名前を入力してください。");
            return false;
        }
        //現在の入室者と同じ名前ではログインできない
        if (isMember(name)==true) {
            alert("現在の参加者と同じ名前ではログインできません。");
            return false;
        }

        //データ成形
        var params =
            '?n='+convert(name)//名前
            +'&s='+'0';//状態表示
        if($("#pwd_off").attr("value")) {
            var pwd = $("#pwd_off").attr("value");
            if(pwd) {
                var params =
                params+'&p='+convert(pwd);//PWD
            }
        } else {
            var pwd = "";
        }
        var params =
            params+'&y=in'
            +'&e='+(new Date()).getTime();//cacheの更新

        writeComment(params);

        //フォームチェンジ
        $("#online1").show();
        $("#online2").show();
        $("#offline").hide();
        document.getElementById("name_on").value = name;
        document.getElementById("pc_name_0").value = name;
        document.getElementById("pwd_on").value = pwd;
        document.getElementById("pc_input_0").focus();

        // 更新
        window.mainframe.login();
    });


    //ログアウト
    $("#logout").click(function(){

        //データ成形
        var name = convert($("#name_on").attr("value"));
        var params =
            '?n='+name//名前
            +'&s='+'0'//状態表示
        if($("#pwd_on").attr("value")) {
            var params =
            params
            +'&p='+convert($("#pwd_on").attr("value"));//PWD
        }
        var params =
            params+'&y=out'
            +'&e='+(new Date()).getTime();//cacheの更新

        writeComment(params);

        //フォームチェンジ
        $("#online1").hide();
        $("#online2").hide();
        $("#offline").show();
        $("#dice_shortcut").hide();
        $(".status_column").hide();
        $(".add_pc").hide();
        $(".show_status").each(function(){
            this.checked = false;
        });
        $("#whisper").click();
        $("#pwd_on").value = "";
        $("#my_hash").value = "";
        $("#name_off").focus();


        // タイマー更新
        window.mainframe.logout();

    });

        // ウィンドウサイズに合わせる
    changeSize();//

});

//-->
</script>
</head>
<body onresize="changeSize()" onunload="return UnLoad()">
<table border="0" cellspacing="3" cellpadding="0" id="online1" class="online" style="display:none;">
<tr>
<td class="nodisplay">
<form id="chat_on" name="chat_on" onsubmit="return false;" action="">
<input type="hidden" name="name_on" value="" size="10" id="name_on">
<input type="hidden" name="pwd_on" size="4" id="pwd_on">
<input type="hidden" name="my_hash" value="" id="my_hash">
</td>
<?php

if (DICE_MAX && $GLOBALS['AJAX_CHAT_TRPG']['PRESET_DICE'][0]) {
    print '<td>';
    print '<select name="dice" id="dice">'."\n";
    foreach ($GLOBALS['AJAX_CHAT_TRPG']['PRESET_DICE'] as $v) {
         print '<option value="'.$v.'">'.$v.'</option>'."\n";
    }
    print '</select></td>'."\n";
    print '<td> + </td>'."\n";
    print '<td>';
    print '<input type="text" size="6" value="" name="revision" id="revision">';
    print '</td>'."\n";
    print '<td>';
    if (CF_INPUT) {
        print '<td nowrap>';
        if (!CF_FIXED) {
            print '<span title="クリティカル値　11:「11で」クリティカル　11-：11「以上」でクリティカル">C:';
        }
        print '<input type="text" size="2" value="';
        print C_DEFAULT;
        print '" name="clit" id="clit"';
        if (CF_FIXED) {
            print ' style="display:none;"';
        }
        print '>';
        if (!CF_FIXED) {
            print '</span>';
        }
        print "</td>\n";
        print '<td nowrap>';
        if (!CF_FIXED) {
            print '<span title="ファンブル　3:「3で」ファンブル　3-：3「以下」でファンブル"> F:';
        }
        print '<input type="text" size="2" value="';
        print F_DEFAULT;
        print '" name="famble" id="famble"';
        if (CF_FIXED) {
            print ' style="display:none;"';
        }
        print '>';
        if (!CF_FIXED) {
            print '</span>';
        }
        print "</td>\n";

        print '<td nowrap>';
        print '<span title="クリティカル・ファンブルを強調表示するダイスを発言欄に入力します">CF入力:<input name="cfinput" id="cfinput" type="checkbox" value="1"><span>';
        print "</td>\n";

    }
    print '<td><input type="image" id="dice" class="btn" src="'.DICE_ICON.'" alt="ダイス入力" title="右で指定したダイスを入力します。" onclick="insertDice(this.form, columnId);"></td>'."\n";
    if (SHORTCUT_DICE) {
        print '<td><input type="image" id="dice_shortcut_icon" class="btn" src="'.DICE_SHORTCUT_SHOW_ICON.'" alt="↓" title="ダイスショートカット欄をON/OFFします。" onclick="toggleColumn(\'dice_shortcut\');if(this.src==\''.str_replace('./image','image',str_replace('index.php','','http://'.$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME']).DICE_SHORTCUT_HIDE_ICON).'\'){this.src=\''.DICE_SHORTCUT_SHOW_ICON.'\';}else{this.src=\''.DICE_SHORTCUT_HIDE_ICON.'\';}"></td>'."\n";
    }
//    if (SW_DICE) {
//        print '<td><input type="image" id="sw_rating" class="btn" src="'.$sw_icon.'" alt="SW" title="SWレーティングを入力します。" onclick="insertRating(this.form, columnId);">';
//        print "</td>\n";
//    }
}

// タグボタン
if (ALLOW_TAG) {
    $tag_num = count($GLOBALS['AJAX_CHAT_TRPG']['TAGS']);
    for($i=0;$i<$tag_num;$i++) {
        if ($GLOBALS['AJAX_CHAT_TRPG']['TAGS'][$i][1] && $GLOBALS['AJAX_CHAT_TRPG']['TAGS'][$i][3]) {
            print '<td>';
            //b</>1</>./image/word_font_b.gif</>1
            print '<input type="image" class="btn" src="'.$GLOBALS['AJAX_CHAT_TRPG']['TAGS'][$i][2].'" alt="'.$GLOBALS['AJAX_CHAT_TRPG']['TAGS'][$i][0].'" title="'.$GLOBALS['AJAX_CHAT_TRPG']['TAGS'][$i][0].'タグ使う" onclick=\'insertTag("'.$GLOBALS['AJAX_CHAT_TRPG']['TAGS'][$i][0].'", columnId);\'>'."\n";
            print '</td>'."\n";
        }
    }
}
if (ALLOW_TAG) {
    print '<td>';
    print '<input type="image" class="btn" src="'.INSERT_FONT_ICON.'" alt="Ｆ" title="フォントタグ使う" onclick=\'insertFontTag(columnId);\'>'."\n";
    print '</td>'."\n";
}
?>

<td><span id="whisper_to_msg" style="display:inline;"> <img name="whisper" id="whisper" title="クリックで「ささやき」を解除します。" src="<?php print WHISPER_ICON; ?>" alt="ささやき解除" align="bottom" hspace="1" vspace="0" border="0" onclick='document.getElementById("whisper_to").value="全員", document.getElementById("whisper_to_hash").value="", document.getElementById("whisper_mark").src="<?php print WHISPER_ON_ICON; ?>"'></td>
<td><img id="whisper_mark" title="「ささやき」状態" src="<?php print WHISPER_ON_ICON; ?>" align="bottom" hspace="1" vspace="0" border="0"></span></td>
<td><input type="text" name="whisper_to" value="全員" size="10" class="inputname" id="whisper_to" style="display:inline;">
<input type="hidden" name="whisper_to_hash" value="" id="whisper_to_hash"></td>
<td><input type="image" id="refresh" class="btn" src="<?php print RELOAD_ICON; ?>" alt="リフレッシュ" title="リフレッシュ" onclick="window.mainframe.clearLog()"></td>

<?php
if (COOKEI_EXPIRE || COOKIE) {
    print '<td><input type="image" id="reload" class="btn" src="'.COOKIE_WRITE_ICON.'" alt="CW" title="現在の設定をクッキーに保管します。" onclick="cookieWrite()"></td>'."\n";
    print '<td><input type="image" id="reload" class="btn" src="'.COOKIE_DELETE_ICON.'" alt="CD" title="現在の設定を削除します。" onclick="cookieDelete()"></td>'."\n";
}
?>
<td align="right" id="logoutBt"><input type="button" value="退室" name="logout" class="btn logout" id="logout" /></td>
<td class="nodisplay"></form></td>
</tr>
</table>
<?php
if (DICE_MAX && SHORTCUT_DICE) {
    print '<table border="0" cellspacing="3" cellpadding="0" id="dice_shortcut" style="display:none;">'."\n";
    print '<tr>'."\n";
    for ($i=1;$i<=5;$i++) {
        $dice_key = "dice_".$i;
        print '<td class="nodisplay"><form onsubmit="return false;"></td>'."\n";
        print '<td><input type="text" name="dice" id="dice_'.$i.'" value="'.$cookies[$dice_key].'" size="10" onblur="selectedColumnId(this, this.form)"></td>'."\n";
        print '<td><input type="image" id="dice" class="btn" src="'.DICE_ICON.'" alt="ダイス入力" title="右欄に設定のダイスを入力します。" onclick=\';insert(document.getElementById(columnId), $("#dice_'.$i.'").attr("value"), 0);\'></td>'."\n";
        print '<td class="nodisplay"></form></td>'."\n";
    }
    print '<td><input type="image" id="dice_shortcut_icon" class="btn" src="'.DICE_SHORTCUT_SHOW_ICON.'" alt="↓" title="ダイスショートカット欄2行目をOH/OFFします。" onclick="toggleColumn(\'dice_shortcut_2\');if(this.src==\''.str_replace('./image','image',str_replace('index.php','','http://'.$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME']).DICE_SHORTCUT_HIDE_ICON).'\'){this.src=\''.DICE_SHORTCUT_SHOW_ICON.'\';}else{this.src=\''.DICE_SHORTCUT_HIDE_ICON.'\';}"></td>'."\n";
    print '<tr id="dice_shortcut_2" style="display:none;">'."\n";
    for ($i=6;$i<=10;$i++) {
        $dice_key = "dice_".$i;
        print '<td class="nodisplay"><form onsubmit="return false;"></td>'."\n";
        print '<td><input type="text" name="dice" id="dice_'.$i.'" value="'.$cookies[$dice_key].'" size="10" onblur="selectedColumnId(this, this.form)"></td>'."\n";
        print '<td><input type="image" id="dice" class="btn" src="'.DICE_ICON.'" alt="ダイス入力" title="右欄に設定のダイスを入力します。" onclick=\';insert(document.getElementById(columnId), $("#dice_'.$i.'").attr("value"), 0);\'"></td>'."\n";
        print '<td class="nodisplay"></form></td>'."\n";
    }

    print '<td>&nbsp;</td>'."\n";
    print '</tr></table>'."\n";
}
?>
<table border="0" cellspacing="3" cellpadding="0" id="online2" class="online" style="display:none;">
<tr>
<td class="nodisplay"><form onsubmit="return false;"></td>
<td align="left" nowrap><input type="text" name="pc_name" size="8" class="pc_name" id="pc_name_0" style="font-weight: bold; color:#<?php print $cookies[pc_color_0]; ?>;" onblur="selectedColumnId(this, this.form)"></td>
<td><input type="text" name="pc_input" class="input_comment" id="pc_input_0" size="75%" onblur="selectedColumnId(this, this.form)"></td>
<td><input type="submit" value="発言" class="btn" id="submit" style="display:inline;" name="submit" onclick="comment(this.form)"></td>
<td><input type="image" class="btn" src="<?php print PC_STATUS_ICON; ?>" alt="状態" title="設定欄をON/OFFします。" onclick="toggleColumn('status_0');"></td>
<?php
if (PC_NUM > 1) {
   print '<td><input type="image" id="PC_btn_0" class="btn" src="'.PC_SHOW_ICON.'" alt="PC欄" title="PC欄を追加/削除します。" onclick="toggleColumn(\'pc_1\');if(this.src==\''.str_replace('./image','image',str_replace('index.php','','http://'.$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME']).PC_HIDE_ICON).'\'){this.src=\''.PC_SHOW_ICON.'\';}else{this.src=\''.PC_HIDE_ICON.'\';}"></td>';
}
 ?>
</tr>
</table>
<table border="0" cellspacing="3" cellpadding="0" class="status_column" id="status_0" style="display:none;">
<tr>
<td nowrap>名前色</td>
<td id="select_color_0">
<select onChange='changeColor(this, this.form)' style="font-weight: bold; color:#<?php print $cookies[pc_color_select_0]; ?>" id="pc_color_select" name="pc_color_select_0">

<?php colorbox("pc_color", $cookies[pc_color_select_0]); ?>
</select>
</td>
<td id="free_color_0" style="display:none;"><input type="text" value="<?php print $cookies[pc_color_0]; ?>" size="12" name="pc_color" id="pc_color_0" style="font-weight: bold; color:#<?php print $cookies[pc_color_0]; ?>" onkeydown='if(navigator.appName == "Netscape"){key=event.which;}else{key=window.event.keyCode;}' onkeyup='changeColor(this, this.form, key);'></td>
<td><input type="image" class="btn" src="<?php echo PC_FONT_ICON; ?>" alt="Ｆ" title="クリックで文字色入力方法を変更できます" onclick='toggleColumn("free_color_0");toggleColumn("select_color_0");'></td>
<td nowrap>ステータス:<input type="text" name="status" class="status" value="<?php print $cookies[pc_status_0]; ?>" id="pc_status_0" onblur="selectedColumnId(this, this.form)" value="
<?php
    if ($cookies[$pc_status_0]) { 
        print $cookies[$pc_status_0];
    } else {
        print STATUS;
    }
 ?>
"></td>
<td><input type="checkbox" name="show_status" class="show_status"></td>
<td nowrap> 表示</td>
<td class="nodisplay"></form></td>
</tr>
</table>

<?php
if (PC_NUM >= 2) {
    for ($i=1; $i<=PC_NUM-1; $i++) {
        $pc_name_key = "pc_name_".$i;
        $pc_color_key = "pc_color_".$i;
        $pc_color_select_key = "pc_color_select_".$i;
        $pc_status_key = "pc_status_".$i;
        print '<table border="0" cellspacing="3" cellpadding="0" id="pc_'.$i.'" class="add_pc" style="display:none;">'."\n";
        print '<tr>'."\n";
        print '<td class="nodisplay"><form onsubmit="return false;"></td>'."\n";
        print '<td align="left" nowrap><input type="text" name="pc_name" value="'.$cookies[$pc_name_key].'" size="8" class="pc_name" id="pc_name_'.$i.'" style="font-weight:bold; color:#'.$cookies[$pc_color_key].'" onblur="selectedColumnId(this, this.form)"></td>'."\n";
        print '<td><input type="text" name="pc_input" class="input_comment" size="75%" id="pc_input_'.$i.'" onblur="selectedColumnId(this, this.form)">';
        print '</td>'."\n";
        print '<td><input type="submit" value="発言" class="btn" id="submit" style="display:inline" name="submit" onclick="comment(this.form)"></td>'."\n";
        print '<td><input type="image" class="btn" src="'.PC_STATUS_ICON.'" alt="状態" title="ステータス欄をON/OFFします。" onclick="toggleColumn(\'status_';
        print $i;
        print '\');"></td>'."\n";
        print '<td width="20">';
        if ($i != PC_NUM-1) {
            print '<input type="image" id="PC_btn_'.$i.'" class="btn" src="'.PC_SHOW_ICON.'" alt="PC欄" title="PC欄を追加/削除します。" onclick="toggleColumn(\'pc_';
            print $i+1;
            print '\');';
            print 'if(this.src==\''.str_replace('./image','image',str_replace('index.php','','http://'.$_SERVER['HTTP_HOST'].$_SERVER['SCRIPT_NAME']).PC_HIDE_ICON).'\'){this.src=\''.PC_SHOW_ICON.'\';}else{this.src=\''.PC_HIDE_ICON.'\';}">';
        } else {
            print " ";
        }
        print '</td>'."\n";
        print '</tr>'."\n";
        print '</table>'."\n";
        print '<table border="0" cellspacing="3" cellpadding="0" class="status_column" id="status_'.$i.'" style="display:none;">'."\n";
        print '<tr>'."\n";
        print '<td nowrap>名前色</td>'."\n";
        print '<td id="select_color_'.$i.'">';
        print '<select onChange=\'changeColor(this, this.form)\' style="font-weight: bold; color:#'.$cookies[$pc_color_key].';" id="pc_color_select" name="pc_color_select_'.$i.'">'."\n";
        colorbox("pc_color", $cookies[$pc_color_select_key]);
        print '</select></td>'."\n";
        print '<td id="free_color_'.$i.'" style="display:none;"><input type="text" value="'.$cookies[$pc_color_key].'" size="12" name="pc_color" id="pc_color_'.$i.'" style="font-weight: bold; color:#'.$cookies[$pc_color_key].';" onkeyup="changeColor(this, this.form)"></td>'."\n";
        print '<td><input type="image" class="btn" src="'.PC_FONT_ICON.'" alt="Ｆ" title="クリックで文字色入力方法を変更できます" onclick=\'toggleColumn("free_color_'.$i.'");toggleColumn("select_color_'.$i.'");\'></td>'."\n";
        print '<td nowrap>ステータス:<input type="text" name="status" class="status" value="';
        if ($cookies[$pc_status_key]) { 
            print $cookies[$pc_status_key];
        } else {
            print STATUS;
        }
        print '" id="pc_status_'.$i.'" onblur="selectedColumnId(this, this.form)"></td>'."\n";
        print '<td><input name="show_status" type="checkbox" class="show_status"></td>'."\n";
        print '<td nowrap> 表示</td>'."\n";
        print '<td class="nodisplay"></form></td>'."\n";
        print '</tr>'."\n";
        print '</table>'."\n";
    }
}
 ?>

<table border="0" cellspacing="3" cellpadding="0" id="offline" style="display:inline;">
<tr>
<td class="nodisplay">
<form id="chat_off" name="chat" onsubmit="return false;" action="">
</td>
<td nowrap>お名前
<input type="text" name="name_off" value="<?php if ($cookies[name_off]) { print $cookies[name_off]; } else { print NONAME; } ?>" size="10" class="inputname" id="name_off">
</td>
<td nowrap>
パスワード<input type="password" name="pwd_off" size="6" class="inputpwd" id="pwd_off">
</td>
<td width="35">
<input type="submit" value="入室" name="login" class="login_btn_area" id="login" />
</td>
<td>
<input type="image" id="reload" class="btn" src="<?php print RELOAD_ICON; ?>" alt="リフレッシュ" title="リフレッシュ" onclick="window.mainframe.location.reload()">
</td>
<td class="nodisplay">
</form>
</td>
<td class="nodisplay">
<form action="<?php print HOME; ?>" target="_self">
</td>
<td>
<input type="image" class="btn" src="<?php print HOME_ICON; ?>" value="submit" alt="ホーム" title="ホーム">
</td>
<td class="nodisplay">
</form>
</td>
<td class="nodisplay">
<form action="./pastlog_index.php" method="<?php print METHOD; ?>" target="pastlog">

</td>
<td>
<input type="submit" value="過去ログ表示">
</td>
<td class="nodisplay">
</form>
</td>
</tr>
</table>

<iframe src="./main.php" width="100%" frameborder="1" border="1" allowtransparency="true" scrolling="auto" name="mainframe" class="mainframe" style="height:500px;" id="mainframe"></iframe>

<noscript>
<p><img src="image/blog_jscript.gif" alt="Javascript" width="80" height="15">本チャットは、JavaScript が有効な環境でのみ使用可能です</p>
</noscript>

<?php

// フッター
print html_footer(true, true);

exit;
 ?>