<?php
/*
 * Ajax Chat for TRPG ver.1.3
 * (c)2007 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*****************
 *  PHPライブラリ：書きこみ用
 *****************/

/*
 * 直近の過去ログ取得
 */
function write_recent_past($write, $pdata) {
    $pfp = @fopen($pdata, "a+") or die("過去ログファイルを開けません。");

    fwrite($pfp, $write);

    return true;
}



/**************
 * ダイス
 **************/

/*
 * 基本のダイス
 */
function dice_convert($dicenum, $dicenumber, $revision, $c, $f) {
    // ダイス本体
    list($dice_sum, $dice_list, $d_result, $error) = dice_main($dicenum, $dicenumber, $revision);

    // 修正値を加えた結果
    if($revision) {
        $dice = preg_replace("/\s/","+",$dice);
        list($value, $error) = calc_value($dice_sum, $revision);
    } else {
        $value = $dice_sum;
    }

    if ($error) {
        return $error;
    }

    $dice = '; font-weight: bold;">['.$dicenum.'d'.$dicenumber.$revision;
    if ($c || $f) {
        $dice .= '@'.$c.$f;
    }
    $dice .= '] :'.$dice_list.' = '.$value.'</span> ';

    // クリティカル・ファンブル
    list($flg_c, $flg_f) = cf_check($dice_sum, $c, $f);
    if ($flg_c) {
        $dice = ' <span style="color:#'.C_COLOR. $dice;
    } elseif ($flg_f) {
        $dice = ' <span style="color:#'.F_COLOR. $dice;
    } else {
        $dice = ' <span style="color:#'.DICE_COLOR. $dice;
    }

    return $dice;
}

/*
 * ダイス本体
 */
function dice_main($dicenum, $dicenumber, $revision) {
    if ((int)DICE_MAX > 1000) {
        $error = '['.$dicenum.'d'.$dicenumber.$revision.' (ダイス数最大数の設定が誤っています。1000個以下にしてください)]';
    } elseif($dicenum >= 1 && $dicenum <= (int)DICE_MAX) {
        if ($dicenumber >= 2 && $dicenumber <= 100) {
            mt_srand((double) microtime() * 1000000);
            $dicesum = 0;
            for ($i=0; $i<$dicenum; $i++) {
                $d_result[$i] = mt_rand(1,$dicenumber);
                $dice_sum += $d_result[$i];
                if ($i != 0) {
                    $dice_list .= ", ".$d_result[$i];
                } else {
                    $dice_list = " (".$d_result[$i];
                }
            }
            $dice_list .= ")";
        } else {
            $error = '['.$dicenum.'d'.$dicenumber.$revision.' (d2～d100の範囲で指定してください)]';
        }
    } else {
        $error = '['.$dicenum.'d'.$dicenumber.$revision.' (ダイスの数は1から'.DICE_MAX.'の間で指定してください)]';
    }
    return array($dice_sum, $dice_list, $d_result, $error);
}

/*
 * ダイス修正値の計算
 */
function calc_value($dice_sum, $revision) {
    $multi = preg_match("/\*/", $revision);
    $dev = preg_match("/\//", $revision);
    $add = preg_match("/\+/", $revision);
    $subtract = preg_match("/\-/", $revision);

    // +-*/で分割
    $revision = preg_replace("/\+/","<>+<>",$revision);
    $revision = preg_replace("/\-/","<>-<>",$revision);
    $revision = preg_replace("/\*/","<>*<>",$revision);
    $revision = preg_replace("/\//","<>/<>",$revision);
    $parts = explode("<>",$revision);
    array_splice($parts, 0, 1, $dice_sum);

    // 乗算&除算
    if ($multi || $dev) {
        foreach ($parts as $k => $v) {
            if ($v != '0' && $v == '*') {
                if (!preg_match("/[0-9]{1,}/", $parts[$k+1])) $error = "演算子が連続してます";
                $flg = $k;
                array_splice($parts, $k+1, 1, $parts[$k-1] * $parts[$k+1]);
                array_splice($parts, $k-1, 1, 0);
                array_splice($parts, $k, 1, $parts[$k-2]);
                array_splice($parts, $k-2, 1, '+');
            }
            if ($v != '0' && $v == '/') {
                if (!preg_match("/[0-9]{1,}/", $parts[$k+1])) $error = "演算子が連続してます";
                array_splice($parts, $k+1, 1, $parts[$k-1] / $parts[$k+1]);
                array_splice($parts, $k-1, 1, 0);
                array_splice($parts, $k, 1, $parts[$k-2]);
                array_splice($parts, $k-2, 1, '+');
            }
        }
    }

    // 加減算
        foreach ($parts as $k => $v){
            if ($v != '0') {
                if ($v == '+') {
                    if (!preg_match("/[0-9]{1,}/", $parts[$k+1]))  $error = "演算子が連続してます";
                    array_splice($parts, 0, 1, $parts[0] + $parts[$k+1]);
                } elseif ($v == '-') {
                    if (!preg_match("/[0-9]{1,}/", $parts[$k+1]))  $error = "演算子が連続してます";
                    array_splice($parts, 0, 1, $parts[0] - $parts[$k+1]);
                }
            }
        }

    return array(round($parts[0], 1), $error);
}

/*
 * クリティカル･ファンブル
 */
function cf_check($dice_sum, $c, $f) {
    if ($c || $f) {
        if ($c && preg_match("/^[cC]([0-9]{1,})([\-]{0,})$/i", $c, $clit)) {
            if ($clit[2] && $dice_sum >= $clit[1]) {
                $flg_c = true;
            } elseif (!$clit[2] && $dice_sum == $clit[1]) {
                $flg_c = true;
            } else {
                $flg_c = false;
            }
        }
        if ($f && preg_match("/^[fF]([0-9]{1,})([\-]{0,})$/i", $f, $famble)) {
            if ($famble[2] && $dice_sum <= $famble[1]) {
                $flg_f = true;
            } elseif (!$famble[2] && $dice_sum == $famble[1]) {
                $flg_f = true;
            } else {
                $flg_f = false;
            }
        }
    }
    return array($flg_c, $flg_f);
}

 ?>