<?php
/*
 * Ajax Chat for TRPG ver.2.1
 * (c)2007-2008 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';

// 設定セット
set_config(read_config());
require_once './trpgchat-ini-help.php';

// アクセスブロック
access_block();

// HTML出力
print html_header(CHAT_TITLE.' ログ表示画面', 'main', true, true);

// JavaScript読み込み
require_once './lib/js/trpgchat-js.php';
require_once './lib/js/main-js.php';

// COOKIE読み込み
$cookies = read_cookie();
if (!intval($cookies['fontsize'])) $cookies['fontsize'] = 12;
if (!intval($cookies['linespace'])) $cookies['linespace'] = 0;

 ?>
<script type="text/javascript">
<!--

// 起動時の処理
$(function()
{

    //ログの取得
    getLog();
    fontSizeChange("0");
    // タイマー
    Timer = setInterval('getLog()', getdata_off);
});

//-->
</script>
</head>
<body>
<div id="help" class="help" style="display:inline;">
<?php
print nl2br(OFFWINDOW_MSG);
if(SHOW_STATIC_OFFWINDOW_MSG) print nl2br($offline_static_msg);
?>
<hr class="break_hr" style="border-style:inset;">
</div>
<div class="chatwindow">
<table style="border-style:none; width:100%;" id="main_console">
<tr><td>
参加者： <span id="indi"></span>
</td><td style="width:120px; text-align:right;" nowrap>
<input type="image" class="btn" src="<?php print FONT_SIZE_UP; ?>" alt="縮小" title="文字を大きくします。" onclick="fontSizeChange('2');">
<input type="image" class="btn" src="<?php print FONT_SIZE_DOWN; ?>" alt="縮小" title="文字を小さくします。" onclick="fontSizeChange('-2');">
<input type="hidden" value="<?php print $cookies['fontsize']; ?>" id="fontsize">
<input type="image" class="btn" src="<?php print LINE_SPACE_UP; ?>" alt="広く" title="行間隔を広めます" onclick="lineSpaceChange('4');">
<input type="image" class="btn" src="<?php print LINE_SPACE_DOWN; ?>" alt="狭く" title="行間隔を狭めます" onclick="lineSpaceChange('-4');">
<input type="hidden" value="<?php print $cookies['linespace']; ?>" id="linespace">
<input type="image" class="btn" src="<?php print LINE_SPACE_HR; ?>" alt="HR" title="発言間に線を引きます" onclick="lineSpaceHrToggle();">
<input id="hr" type="checkbox" style="display:none;" <?php if ($cookies['hr']===true) print " checked"; ?>>
</td></tr></table>


</div>

<div align="right" id="pastlog" class="pastlog">
<a href="./pastlog_index.php" target="pastlog">もっと前のログを見る</a></div>

<noscript>
<p><img src="image/blog_jscript.gif" alt="Javascript" width="80" height="15">本チャットは、JavaScript が有効な環境でのみ使用可能です。</p>
</noscript>

<?php
// フッター
print html_footer('');
 ?>