<?php
/*
 * Ajax Chat for TRPG ver.2.2
 * (c)2007-2008 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/admin.php';
require_once './lib/config.php';

// パスワードの照合
auth();

// 受信データの成形
if (!$request = request()) {
    error('リクエストを受信できません', true);
}

// 表示設定セット
set_config(read_config(), true);

// アクセスブロック
access_block();

// 編集用設定セット
$lines = config_mode($request['mode']);

// 画面表示：HTML出力
print html_header(CHAT_TITLE_EDIT.$request['mode'].' 管理画面', 'edit_config', true, true);

?>

<script language="JavaScript">
<!--
// 入力欄を増やす(IE限定）
function addColumn(Obj2, targetId) {
    var isMSIE = /*@cc_on!@*/false;
    if (!isMSIE) {
        alert('IE限定機能です');
    }
    var newColumn = document.createElement("input");
    newColumn.value = "";
    newColumn.name = targetId+"[]";
    newColumn.size = 30;
    newColumn.type = "text";

    Obj2.parentNode.insertBefore(newColumn, Obj2);
    Obj2.parentNode.insertBefore(document.createElement("br"), Obj2);

}
//-->
</script>
</head>
<body>
<h2 align="center"><?php print CHAT_TITLE_EDIT.$request['mode']; ?>設定 編集</h2>
<br>
<table cellspacing="0" align="center" style="border-style:none;">
<form action="./write_config.php" method="<?php print METHOD; ?>">
<input type="hidden" name="mode" value="<?php print $request['mode']; ?>">
<tr><td style="padding:3px; width:100%; border-style:none;">

<?php

// 設定編集フォームの表示
foreach ($lines as $k1 => $v1) {
    $v1 = rtrim($v1);
    if ($v1) {
        $config = explode("<>", $v1);
        if (!$config[2]) {
            if ($k1 != 0) {
                print '</table><p align="center"><input type="submit" value="設定する"></p><hr>'."\n";
            }
            print '<span style="font-size:18px; ">　<b>'.$config[0]."</b></span>";
            print '<table cellspacing="0" align="center" style="width:100%;">'."\n";
        } else {
            // 設定項目名
            print '<tr><td style="width:350px; padding:3px; border-right-style:none;">'."\n";
            print $config[0]."\n";
            print '</td><td style="padding:3px;">'."\n";
            // 設定内容
            // 変数
            if ($config[3]==0) {
                // INPUT
                if($config[4] == 0) {
                    if ($config[5] == 'image') {
                        print '<img src="'.$config[6].'" id="'.$config[2].'_icon_image">';
                    }
                    print '<input type="text" value="'.$config[6].'" name="'.$config[2].'" id="'.$config[2].'" size="60">'."\n";
                // TEXTAREA
                } elseif ($config[4] == 1) {
                    print '<textarea name="'.$config[2].'" id="'.$config[2].'" cols="45" rows="3">'.str_replace(array("<br>","<br />"), array("\n","\n"), $config[6]).'</textarea>'."\n";
                // 使用・未使用の選択
                } else {
                    print '<input type="radio" name="'.$config[2].'" value="1" id="'.$config[2].'"';
                    if ($config[6]) print ' checked';
                    print '>はい　'."\n";
                    print '<input type="radio" name="'.$config[2].'" value="0" id="'.$config[2].'"';
                    if (!$config[6]) print " checked";
                    print '>いいえ'."\n";
                }
            // 配列
            } elseif ($config[3] == 1) {
                $config2 = explode("</>", $config[6]);
                print '<div id="'.$config[2].'">';
                $num = count($config2);
                if ($config[2] != "COLOR_CODE") $num += 2;
               for ($i=0;$i<$num;$i++) {
                  print '<input type="text" value="'.$config2[$i].'" name="'.$config[2].'[]" size="30"><br>'."\n";
                }

                print '<div style="text-align:right;" ';
                if ($config[2] != "COLOR_CODE" && strstr($_SERVER['HTTP_USER_AGENT'], "MSIE")) {
                    print ' onClick="addColumn(this, \''.$config[2].'\');"><u>設定欄を追加する</u></div>';
                } elseif ($config[2] != "COLOR_CODE") {
                    print '>これより多く設定したい場合は再追加して下さい';
                } else {
                    print ">";
                }
                print "</div>\n";
                print "</div>\n";
            // 二次配列の設定(タグ設定）
            } else {
                for ($i=0;$i<=count($config)-7;$i++) {
                    $config2 = explode("</>", $config[$i+6]);
                    // 使用タグ
                    if ($i) print "<hr>\n";
                    print '<font size="+1"><b>&lt;'.$config2[0].'&gt;</b></font> タグ使用　';
                    print '<input type="radio" name="tag['.$config2[0].'][1]" value="1"';
                    if ($config2[1]) print ' checked';
                    print '>する　'."\n";
                    print '<input type="radio" name="tag['.$config2[0].'][1]" value="0"';
                    if (!$config2[1]) print ' checked';
                    print '>しない'."<br>\n";
                    // アイコン表示
                    print 'アイコン表示　<input type="radio" name="tag['.$config2[0].'][3]" value="1"';
                    if ($config2[3]) print ' checked';
                    print '>する　'."\n";
                    print '<input type="radio" name="tag['.$config2[0].'][3]" value="0"';
                    if (!$config2[3]) print " checked";
                    print '>しない'."<br>\n";
                    print '<div';
                    if (!$config2[3]) {
                        print ' style="display:none;"';
                    }
                    print '><img src="'.$config2[2].'" id="'.$config2[0].'_icon_image">';
                    print '　<input type="text" name="tag['.$config2[0].'][2]" value="'.$config2[2].'" size="40"></div>';
                }
            }
            print "</td></tr>\n";
            if ($config[1]) {
                print '<tr><td colspan="2" style="padding:3px; border-top-style:none;">'."\n";
                print $config[1]."\n";
                print "</td></tr>\n";
            }
        }
    }
}
print '</table>';
print '<p align="center"><input type="submit" value="設定する"></p><hr></form></td></tr>'."\n";
print '</table>'."\n";

// フッター
print html_footer();

?>