<?php
/*
 * Ajax Chat for TRPG ver.2.2
 * (c)2007-2008 Cake All rights reserved.
 * Mail : cake_67@users.sourceforge.jp
 * Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';

// 受信データの成形
if (!$request = request()) {
    error('リクエストを受信できません', true);
}

// パスワードの照合
auth();

// アクセスブロック
access_block();

// 設定セット
set_config(read_config());

if ($request['type'] == 'public') {
    $dir = PAST_DIR;
} elseif ($request['type'] == 'admin') {
    $dir = MASTER_PAST_DIR;
} else {
    error('データが正しく送信されていません。', true);
}

$type = $request['type'];

if (!$request['filename'][0]) {
    error('ファイルを指定してください。', true);
}

print html_header(CHAT_TITLE.' 過去ログ削除確認', 'admin', false, true);

print '<h2>削除確認</h2>'."\n<br>";
print '<p><font color="#FF0000">以下の過去ログを削除します。よろしいですか？</font></p>'."\n";
print '<form action="./admin.php" method="'.METHOD.'">'."\n";
print '<input type="hidden" name="mode" value="delete_log">'."\n";
print '<input type="hidden" name="type" value="'.$type.'">'."\n";
print '<ul>'."\n";
foreach ($request['filename'] as $k => $v) {
    print '<li><input type="hidden" name="filename[]" value="'.$v.'"> <a href="'.$dir.$v.'" target="admin_past">'.$v.'</a></li>'."\n";
}
print '</ul>'."\n";
print '<p><input type="submit" value="削除する"></p>'."\n";
print '</form>'."\n";
print html_footer('');
exit;

?>