<?php
/*
 Ajax Chat for TRPG ver.2.6.1
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/member_check.php';

// 設定セット
set_config(read_config());
$ua = getenv("HTTP_USER_AGENT");

// アクセスブロック
access_block();

// COOKIE読み込み
$cookies = read_cookie();
if (!intval($cookies['fontsize'])) $cookies['fontsize'] = 12;
if (!intval($cookies['linespace'])) $cookies['linespace'] = 0;
define('MAIN_BREAK_STYLE_DEFAULT', $GLOBALS['AJAX_CHAT_TRPG']['MAIN_BREAK_STYLE'][0]);

// HTML出力
print html_header(CHAT_TITLE.' ログ表示画面', 'main', true, true);

// JavaScript読み込み
require_once './lib/js/trpgchat-js.php';
require_once './lib/js/main-js.php';

 ?>
</head>
<body>
<div class="chatwindow" id="chatwindow">
<table style="border-style:none; width:100%;" id="main_console">
<tr><td>
参加者： <span id="indi"></span>
</td>
<?php if (USE_SE): ?>
<td id="soundEffect">
<ul>
<?php if (strstr($ua, "MSIE ")):  ?>
<bgsound id="se" src="./sound_effect/none.wav" loop="1">
<?php else: ?>
<embed id="se" src="./sound_effect/none.wav" loop="1">
<?php endif; ?>
<li style="display:none;">
<input id="seSetting" type="checkbox"<?php if ($cookies['se']): ?> checked="checked"<?php endif ?>>
</li>
<li id="seBottun">
<?php 
show_icon(SE_ON, "", "seIcon", "seOn", "♪", "発言音ON/クリックでOFFにします", "seOff();");
show_icon(SE_OFF, "", "seIcon", "seOff", "×♪", "発言音OFF/クリックでONにします", "seOn();");
show_icon(SE_CONFIG, "", "seIcon", "seConfig", "+♪", "発言音設定/クリックで設定が隠れます", "seConfigHide();");
?>
</li>
<li>
<?php 
$seConfig = '<dl>';
$seConfig .= '<dt><input id="userSetting" type="checkbox"';
if ($cookies['use']) {
    $seConfig .= ' checked="checked"';
}
$seConfig .= ">発言</dt>";
$seConfig .= '<dd>自分以外の発言に音を鳴らす</dd>';
$seConfig .= '<dt><input id="systemSeSetting" type="checkbox"';
if ($cookies['sse']) {
    $seConfig .= ' checked="checked"';
}
$seConfig .= ">入退室など</dt>";
$seConfig .= '<dd>システムメッセージ(入退室など)に音を鳴らす</dd>';
$seConfig .= '</dl>';

write_console('20px', '150px', '190px', 'none', 'seSelect', '発言音設定', $seConfig, '', '', false);

 ?>
</td>
<?php endif; ?>
<td id="lineConfig" nowrap>
<?php
show_icon(FONT_SIZE_UP, "", "", "", "拡大", "文字を大きくします", "fontSizeChange('2');");
show_icon(FONT_SIZE_DOWN, "", "", "", "縮小", "文字を小さくします", "fontSizeChange('-2');");
show_icon(LINE_SPACE_UP, "", "", "", "広く", "行間隔を広めます", "lineSpaceChange('4');");
show_icon(LINE_SPACE_DOWN, "", "", "", "狭く", "行間隔を狭めます", "lineSpaceChange('-4');");
show_icon(LINE_SPACE_HR, "", "", "line_hr", "HR", "発言間に線を引きます", "");
?>
<input type="hidden" value="<?php print $cookies['fontsize']; ?>" id="fontsize">
<input type="hidden" value="<?php print $cookies['linespace']; ?>" id="linespace">
<select name="hr" id="hr" style="display:none;">
<?php
if ($GLOBALS['AJAX_CHAT_TRPG']['MAIN_BREAK_STYLE']) {
    foreach ($GLOBALS['AJAX_CHAT_TRPG']['MAIN_BREAK_STYLE'] as $k => $v) {
        if (!$v) continue;
        print '<option value="'.$v.'"';
        if ($cookies['hr'] == $v) {
            print ' selected';
        }
        print '>'.$v.'</option>'."\n";
    }
} else {
    print '<option value="none">none</option>'."\n";
}
?>
</select>
</td></tr>

<?php if (!FLOW_DESC && !(DELETE_LAST_PASTLOG && !PUBLIC_PASTLOG)): ?>
<tr><td colspan="3" align="right">
<a href="./pastlog_index.php" target="pastlog">もっと前のログを見る</a>
</td></tr>
<?php endif; ?>

</table>


<div align="right" id="pastlog" class="pastlog">
<?php if (!FLOW_DESC): ?>
<input id="isScrollBottom" type="checkbox">常に最新の行を表示 
<?php elseif (!(DELETE_LAST_PASTLOG && !PUBLIC_PASTLOG)): ?>
<a href="./pastlog_index.php" target="pastlog">もっと前のログを見る</a>
<?php endif; ?>
</div>

</div>

<noscript>
<p><img src="image/blog_jscript.gif" alt="Javascript" width="80" height="15">本チャットは、JavaScript が有効な環境でのみ使用可能です。</p>
</noscript>

<?php
// フッター
print html_footer('');
 ?>