<?php
/*
 Ajax Chat for TRPG ver.2.6.2.1
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/* カード用発言書込み */

// デバッグ用設定
ini_set('log_errors', false);
ini_set('error_log', "./php_error.log");

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
//require_once './lib/write.php';
require_once './lib/member_check.php';

// 設定セット
set_config(read_config());

// ユーザの情報
if (REC_UA) {
    $host = gethostbyaddr($_SERVER['REMOTE_ADDR']);
    $ua = getenv("HTTP_USER_AGENT");
}

// 書き込みブロック
write_block();

// アクセスブロック
access_block();

// リクエスト受信
if (!$request = $_GET) {
    error('データを受信できません');
}

// secretTo設定
if ($request['w2']) {
    if (OBFUSCATION) {
        $target_member = obf_xor($request['w2']);
    } else {
        $target_member = $request['w2'];
    }

    // 参加者チェック
    $member_data = get_member_log();
    if ($member_data) {
        foreach ($member_data as $v) {
            $mname = $v[0];
            $mhash = $v[1];

            // 在室かつパスワードありで、相手にも「ささやき」カード発言
            if ($mname == $target_member && $mhash) {
                $flag = true;
                if (OBFUSCATION) {
                    $mname = de_obf_xor($mname);
                }
                $request['n'] = $request['w'];
                $request['w'] = $mname;
                $request['h'] = $mhash;
//                $request['p'] = $mhash;


                break;
            }
        }
    }
}
$request['e'] = time();
unset($request['w2']);

// 本文をwrite.phpへパス
$self_url = get_self_url();
$params = http_build_query($request);
$url = str_replace('card_write.php', 'write.php', $self_url).'/?';
header('Location: '. $url.$params);

exit;

?>
