<?php
/*
 Ajax Chat for TRPG ver.2.6.2.1
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*****************
 *  PHPライブラリ：カード機能用
 *****************/

// 外部ライブラリの読み込み
require_once './lib/Jsphon/Encoder.php';
require_once './lib/Jsphon/Decoder.php';

/*
 * ログ基本整形
 */
function read_card_ini()
{
    // カードパスワード
    $user_password = get_user_password();

    $card_inifile_list = get_dir_contents_list(CARD_DIR, 'ASC', true);

    // 設定ファイル読み込み
    $card_ini = array();
    if ($card_inifile_list) {
        // サブディレクトリ読み込みは現状なし
        foreach($card_inifile_list['files'] as $v) {
            $card_ini[] = parse_ini_file(CARD_DIR.$v, true);
        }

        // order設定順にソート
        foreach ($card_ini as $k => $v) {
            // パスワードチェック
            $pwd_flg = false;
            if ($v['config']['password']) {
                $deck_password = md5($v['config']['password'].ADMIN_HASH_KEY);

                if ($deck_password != $user_password) {
                    unset($card_ini[$k]);
                    $pwd_flg = true;
                }
            }

            if (!$pwd_flg) {
                $order[$k]  = $v['config']['order'];
            }
        }
        array_multisort($order, SORT_ASC, $card_ini);
    }
    return $card_ini;
}

/* 
 * 配列をJSONへパース
 */
function set_array2json($data)
{
    if (!is_array($data)) {
        $data = array();
    }

    $json = new Jsphon_Encoder(false);
    $purse = $json->encode($data);

    return $purse;
}

/* 
 * JSONを配列へパース
 */
function set_json2array($data)
{
    if (!$data) {
        $data = array();
    }

    $json = new Jsphon_Decoder(false);
    $arr = $json->decode($data);

    return $arr;
}

/* 
 * カード配置セット
 */
function card_status($plname, $card_id, $status='Secret', $is_open=false, $is_head=false, $force='')
{
    // 前処理
    $plname = addslashes($plname);

    // 難読化
    if (OBFUSCATION) {
        $plname = obf_xor($plname);
        $card_id = obf_xor($card_id);
    }

    // カードを配置
    $GLOBALS['AJAX_CHAT_TRPG']['deck']['status'][$plname][$status]['card'][] = array(
        'id' => $card_id,
        'open' => $is_open,
        'head' => $head,
    );
}

// カード移動
function setMoveCard($target, $a)
{
    // カードを出す場合
    if ($a == 'd') {
        $target['open'] = false;
    // カードを出す場合
    } elseif ($a == 'c') {
        $target['open'] = true;
    }

    return $target;
}

// カード移動書き込み補助
function writeMoveCard($fromName, $fromPlace, $toName, $toPlace, $num, $toMe) {
    $msg = '';
    $from = setCardName($fromName, $fromPlace);
    $to = setCardName($toName, $toPlace);
    $msg .= $from.'から';
    $msg .= $to.'に';
    if ($num) {
        $msg .= $num.'枚';
    }
    if ($toPlace == 'Field') {
            $msg .= '出しました。';
            $action = '出した';
            $is_secret = false;
    } else {
        if ($toName == 'deckCardSet') {
            $msg .= '戻しました。';
            $action = '戻した';
        } else {
            if ($toMe) {
                $msg .= '引きました。';
                $action = '引いた';
            } else {
                $msg .= '渡しました。';
                $action = '渡した';
            }
        }
        if ($fromPlace == 'Secret') {
            $is_secret = true;
        } else {
            $is_secret = false;
        }
    }
    return array($msg, $action, $is_secret);
}
function setCardName($name, $place) {
    if ($name == 'deckCardSet') {
        if ($place == 'Secret') {
            return '山札';
        } else {
            return '場札';
        }
    } else {
        if ($place == 'Secret') {
            return $name.'さんの手札';
        } elseif ($place == 'Field')  {
            return $name.'さんの場札';
        }
    }
    return false;
}
function setCardMoveDetailForWriteToChat($action, $is_secret) {
    $write_msg = array();
    $write_msg['msg'] = $action.'カード：';
    if ($is_secret) {
            $write_msg['isSecret'] = $action.'カード：';
    }

    return $write_msg;
}

// 指定カードの移動
function moveCardByTargetId(&$deck_status, $target_card, $from, $to, $fieldFrom, $fieldTo, $head) {
    if (OBFUSCATION) {
        $target_card_id = de_obf_xor($target_card[0]['id']);
    } else {
        $target_card_id = $target_card[0]['id'];
    }

    // カード公開
    // 山・手は非公開
    if ($fieldTo == 'Secret') {
        $target_card[0]['open'] = false;
    // 場は公開
    } else {
        $target_card[0]['open'] = true;
    }

    // 正逆を指定
    if (isset($head)) {
        // 正逆ランダムでカードを出す
        if ($head == 'rand') {
            mt_srand((double) microtime() * 1000000);
            $target_card[0]['head'] = (bool)(mt_rand(1, 6) % 2);
            if ($target_card[0]['head']) {
                $card_head = true;
            }
        // 指定あり:正
        } elseif ($head) {
            $target_card[0]['head'] = $head;
            $card_head  = true;
        // 指定あり:逆
        } else {
            $target_card[0]['head'] = NULL;
        }
    } else {
        $target_card[0]['head'] = NULL;
    }

    if (!is_array($deck_status[$to][$fieldTo]['card'])) {
        $deck_status[$to][$fieldTo]['card'] = array();
    }
    array_push($deck_status[$to][$fieldTo]['card'], $target_card[0]);

    return array($target_card_id, $card_head);
}

// カードパスワード（ユーザ側）セッション開始
function init_user_password() {
    $session_name = COOKIE.'Card';
    @session_name($session_name);
    @session_start();
}

// カードパスワード（ユーザ側）取得
function get_user_password() {
    init_user_password();

    return $_SESSION['deck_pwd'];
}

// カードパスワード（ユーザ側）設定
function set_user_password($password) {
    init_user_password();
    @session_regenerate_id();

    $_SESSION['deck_pwd'] = md5($password.ADMIN_HASH_KEY);
}

