<?php
/*
 Ajax Chat for TRPG ver.2.6.2
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/* クッキーファイル保存 */

// SSL&IE対策
session_cache_limiter('public');

// デバッグ用設定
ini_set('log_errors', false);
ini_set('error_log', "./php_error.log");

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';

// 設定セット
set_config(read_config());

// クッキー無効
if (!COOKIE || !intval(COOKEI_EXPIRE)) {
    error("クッキー無効のため、保存できません");
}

// ユーザの情報
if (REC_UA) {
    $host = gethostbyaddr($_SERVER['REMOTE_ADDR']);
    $ua = getenv("HTTP_USER_AGENT");
}

// 書き込みブロック
write_block();

// アクセスブロック
access_block();

// リクエスト受信
if (!$request = $_GET) {
    error('データを受信できません');
}

// クッキー情報がない
if (!$request['c']) {
    error("データがありません");
}

// このチャットのクッキー情報か
if(strpos($request['c'], 'name_off=', 0) === false) {
    error("このデータは保存できません");
}

// ファイル名処理
if ($request['f']) {
    $filename = $request['f'];
} else {
    $filename = 'AjaxChatForTRPG';
}

 // IEの場合
if (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false) {
    // ファイル名を SJIS に変換
    $filename = mb_convert_encoding($filename, 'SJIS', 'UTF-8');
}
$filename = str_replace(array("\r", "\n"), '', $filename);
$filename .= '.txt';

// 出力
header("Content-type: text/plain");
header("Content-Disposition: attachment; filename=$filename");
header("Content-length: ".strlen($request['c']));
print $request['c'];

exit;

?>
