#ifndef TSREMUXCPP_MKV_H_
#define TSREMUXCPP_MKV_H_

#include "Utils.h"
#include "define_temporary.h"
#include "define_backgroundworker.h"

namespace TsRemux {

enum LacingType {
    NoLacing = 0,
    XiphLacing,
    FixedSizeLacing,
    EbmLacing
};

class EbmlElement {
 public:
  static boost::shared_ptr<EbmlElement> ParseEbml(Stream fs);
  Int64 GetId(void);
  void SetId(Int64 id);
  Int64 GetSize(void);
  void SetSize(Int64 size);
  Int64 GetPos(void);
  void SetPos(Int64 pos);
  boost::shared_ptr<Stream> GetStream(void);
  void SetStream(boost::shared_ptr<Stream> fs);
  Stream DataStream;
  boost::shared_ptr<EbmlElement> Children;
  static byte VintLength(char vint);
  static Int64 VintToInt64(Stream fs);
 protected:
  Int64 id;
  Int64 size;
  Int64 pos;
  boost::shared_ptr<Stream> fs;
  EbmlElement(Int64 id, Int64 size, Int64 pos, boost::shared_ptr<Stream> fs);
};

struct TrackInfo {
 public:
  TrackInfo(ushort pid, std::string codec, pByte data, EbmlElement& info);
  ushort pid;
  std::string codec;
  pByte data;
  EbmlElement info;
};

class MkvPesFile {
 public:
  MkvPesFile(BackgroundWorker& bw);
  DTCP_Descriptor DtcpInfo;
  boost::shared_array<PesPacket> GetNextPesPackets(void);
  void Seek(Int32 pcr);
 protected:
  void GetInitialValues(void);
 private:
  SortedList<Int64, EbmlElement> Clusters;
  Int32 CuurentIndex;
  Dictionary<ushort, TrackInfo> TrackList;
  UInt64 GetClusterClock(EbmlElement cluster);
  PesPacket BuildAc3Pes(Int64 timestamp, pByte data, ushort pid);
  PesPacket BuildMpeg2Pes(Int64 timestamp, pByte data, ushort pid);
  PesPacket BuildAvcPes(Int64 timestamp, pByte data, ushort pid);
  PesPacket BuildVc1Pes(Int64 timestamp, pByte data, ushort pid);
  void GetTimeStamps(void);
};
}
#endif

