﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Xml;
using System.Xml.Linq;
using System.IO;

namespace TwitterListManager
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
        }

        private void MainForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            Properties.Settings.Default.Save();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (backgroundWorker1.IsBusy)
            {
                MessageBox.Show("リスト取得中です");
                return;
            }
            backgroundWorker1.RunWorkerAsync();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            var doc = new XDocument();
            var root = new XElement("TwitterListInfo");
            doc.Add(root);
            foreach (TreeNode item in treeView1.Nodes)
            {
                var node = new XElement("list");
                node.Add(new XElement("name", item.Text));
                root.Add(node);
                foreach (TreeNode item2 in item.Nodes)
                {
                    node.Add(new XElement("user", item2.Text));
                }
            }

            doc.Save("TwitterListInfo.xml");
            MessageBox.Show("TwitterListInfo.xml に保存しました");
        }

        private void button3_Click(object sender, EventArgs e)
        {
            var doc = XDocument.Load("TwitterListInfo.xml");
            treeView1.Nodes.Clear();
            foreach (var item in doc.Root.Elements("list"))
            {
                var node = treeView1.Nodes.Add(item.Element("name").Value);
                foreach (var item2 in item.Elements("user"))
                {
                    node.Nodes.Add(item2.Value);
                }
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            var save = new SaveFileDialog();
            save.RestoreDirectory = true;
            save.Filter = "Tweenタブ設定ファイル|SettingTabs.xml";
            if (save.ShowDialog() != DialogResult.OK)
            {
                return;
            }

            var doc = new XDocument();
            var settingtabs = new XElement("SettingTabs",
                new XAttribute(XNamespace.Xmlns.GetName("xsi"), "http://www.w3.org/2001/XMLSchema-instance"),
                new XAttribute(XNamespace.Xmlns.GetName("xsd"), "http://www.w3.org/2001/XMLSchema"));
            doc.Add(settingtabs);
            var root = new XElement("Tabs");
            settingtabs.Add(root);

            //デフォで入ってるタブ
            var tabtype_list = new Dictionary<string, string>
            {
                {"Recent", "Home"},
                {"Reply", "Mentions"},
                {"Direct", "DirectMessage"},
                {"Favorites", "Favorites"}
            };
            foreach (var item in tabtype_list)
            {
                var tab = new XElement("TabClass");
                root.Add(tab);
                tab.Add(new XElement("SearchLang"));
                tab.Add(new XElement("SearchWords"));
                tab.Add(new XElement("UnreadManage", true));
                tab.Add(new XElement("Notify", true));
                tab.Add(new XElement("SoundFile"));
                tab.Add(new XElement("FilterArray"));
                tab.Add(new XElement("TabName", item.Key));
                tab.Add(new XElement("TabType", item.Value));
            }

            foreach (TreeNode node in treeView1.Nodes)
            {
                var tab = new XElement("TabClass");
                root.Add(tab);
                tab.Add(new XElement("SearchLang"));
                tab.Add(new XElement("SearchWords"));
                tab.Add(new XElement("UnreadManage", true));
                tab.Add(new XElement("Notify", true));
                tab.Add(new XElement("SoundFile"));
                var filter = new XElement("FilterArray");
                tab.Add(filter);
                foreach (TreeNode node2 in node.Nodes)
                {
                    var filter_class = new XElement("FiltersClass");
                    filter.Add(filter_class);
                    filter_class.Add(new XElement("NameFilter", node2.Text));
                    filter_class.Add(new XElement("ExNameFilter"));
                    filter_class.Add(new XElement("BodyFilterArray"));
                    filter_class.Add(new XElement("ExBodyFilterArray"));
                    filter_class.Add(new XElement("SearchBoth", true));
                    filter_class.Add(new XElement("ExSearchBoth", true));
                    filter_class.Add(new XElement("MoveFrom", false));
                    filter_class.Add(new XElement("SetMark", true));
                    filter_class.Add(new XElement("SearchUrl", false));
                    filter_class.Add(new XElement("ExSearchUrl", false));
                    filter_class.Add(new XElement("CaseSensitive", false));
                    filter_class.Add(new XElement("ExCaseSensitive", false));
                    filter_class.Add(new XElement("UseRegex", false));
                    filter_class.Add(new XElement("ExUseRegex", false));
                    filter_class.Add(new XElement("IsRt", false));
                    filter_class.Add(new XElement("IsExRt", false));
                    filter_class.Add(new XElement("Source"));
                    filter_class.Add(new XElement("ExSource"));
                }
                tab.Add(new XElement("TabName", node.Text));
                tab.Add(new XElement("TabType", "UserDefined"));
            }

            var backupfile = new FileInfo(save.FileName + ".old");
            if (backupfile.Exists)
            {
                backupfile.Delete();
            }
            File.Move(save.FileName, backupfile.FullName);
            doc.Save(save.FileName);
            MessageBox.Show("SettingTabs.xml に保存しました\nバックアップファイルを" + backupfile.FullName + "に保存しました");
        }

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            backgroundWorker1.ReportProgress(0);
            treeView1.Nodes.Clear();
            var req = HttpWebRequest.Create("http://api.twitter.com/1/" + txtUser.Text + "/lists.xml");
            req.Credentials = new NetworkCredential(txtUser.Text, txtPass.Text);

            var res = req.GetResponse();
            XDocument doc;
            using (var r = res.GetResponseStream())
            using (var rr = XmlReader.Create(r))
            {
                doc = XDocument.Load(rr);
            }
            foreach (var item in doc.Element("lists_list").Element("lists").Elements("list"))
            {
                Invoke(new Action(() => treeView1.Nodes.Add(item.Element("slug").Value)));
            }

            foreach (TreeNode item in treeView1.Nodes)
            {
                string cursor = "";
                do
                {
                    string uri = "http://api.twitter.com/1/" + txtUser.Text + "/" + item.Text + "/members.xml";
                    if (!string.IsNullOrEmpty(cursor))
                    {
                        uri += "?cursor=" + cursor.ToString();
                    }
                    req = HttpWebRequest.Create(uri);
                    req.Credentials = new NetworkCredential(txtUser.Text, txtPass.Text);

                    res = req.GetResponse();
                    using (var r = res.GetResponseStream())
                    using (var rr = XmlReader.Create(r))
                    {
                        doc = XDocument.Load(rr);
                    }

                    foreach (var item2 in doc.Element("users_list").Element("users").Elements("user"))
                    {
                        Invoke(new Action(() => item.Nodes.Add(item2.Element("screen_name").Value)));
                    }
                    cursor = doc.Root.Element("next_cursor").Value;
                } while (cursor != "0");
            }
            backgroundWorker1.ReportProgress(100);
        }

        private void backgroundWorker1_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            if (e.ProgressPercentage == 0)
            {
                progressBar1.Style = ProgressBarStyle.Marquee;
                return;
            }
            progressBar1.Style = ProgressBarStyle.Continuous;
            progressBar1.Value = e.ProgressPercentage;
        }
    }
}
