﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Xml;
using System.Xml.Linq;
using System.IO;
using Twitter;

namespace TwitterListManager
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
        }

        private void MainForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            Properties.Settings.Default.Save();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (backgroundWorker1.IsBusy)
            {
                MessageBox.Show("リスト取得中です");
                return;
            }
            backgroundWorker1.RunWorkerAsync();
        }

        string UserName
        {
            get { return Properties.Settings.Default.UserName; }
        }
        string AccessToken
        {
            get { return Properties.Settings.Default.AccessToken; }
        }
        string AccessTokenSecret
        {
            get { return Properties.Settings.Default.AccessTokenSecret; }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            var doc = new XDocument();
            var root = new XElement("TwitterListInfo");
            doc.Add(root);
            foreach (TreeNode item in treeView1.Nodes)
            {
                var node = new XElement("list");
                node.Add(new XElement("name", item.Text));
                root.Add(node);
                foreach (TreeNode item2 in item.Nodes)
                {
                    node.Add(new XElement("user", item2.Text));
                }
            }

            doc.Save("TwitterListInfo.xml");
            MessageBox.Show("TwitterListInfo.xml に保存しました");
        }

        private void button3_Click(object sender, EventArgs e)
        {
            var doc = XDocument.Load("TwitterListInfo.xml");
            treeView1.Nodes.Clear();
            foreach (var item in doc.Root.Elements("list"))
            {
                var node = treeView1.Nodes.Add(item.Element("name").Value);
                foreach (var item2 in item.Elements("user"))
                {
                    node.Nodes.Add(item2.Value);
                }
            }
        }

        private XDocument CreateXml()
        {
            var doc = new XDocument();
            var settingtabs = new XElement("SettingTabs",
                new XAttribute(XNamespace.Xmlns.GetName("xsi"), "http://www.w3.org/2001/XMLSchema-instance"),
                new XAttribute(XNamespace.Xmlns.GetName("xsd"), "http://www.w3.org/2001/XMLSchema"));
            doc.Add(settingtabs);
            var root = new XElement("Tabs");
            settingtabs.Add(root);

            //デフォで入ってるタブ
            var tabtype_list = new Dictionary<string, string>
            {
                {"Recent", "Home"},
                {"Reply", "Mentions"},
                {"Direct", "DirectMessage"},
                {"Favorites", "Favorites"}
            };
            foreach (var item in tabtype_list)
            {
                var tab = new XElement("TabClass");
                root.Add(tab);
                tab.Add(new XElement("SearchLang"));
                tab.Add(new XElement("SearchWords"));
                tab.Add(new XElement("UnreadManage", true));
                tab.Add(new XElement("Notify", true));
                tab.Add(new XElement("SoundFile"));
                tab.Add(new XElement("FilterArray"));
                tab.Add(new XElement("TabName", item.Key));
                tab.Add(new XElement("TabType", item.Value));
            }

            foreach (TreeNode node in treeView1.Nodes)
            {
                var tab = new XElement("TabClass");
                root.Add(tab);
                tab.Add(new XElement("SearchLang"));
                tab.Add(new XElement("SearchWords"));
                tab.Add(new XElement("UnreadManage", true));
                tab.Add(new XElement("Notify", true));
                tab.Add(new XElement("SoundFile"));
                var filter = new XElement("FilterArray");
                tab.Add(filter);
                foreach (TreeNode node2 in node.Nodes)
                {
                    var filter_class = new XElement("FiltersClass");
                    filter.Add(filter_class);
                    filter_class.Add(new XElement("NameFilter", node2.Text));
                    filter_class.Add(new XElement("ExNameFilter"));
                    filter_class.Add(new XElement("BodyFilterArray"));
                    filter_class.Add(new XElement("ExBodyFilterArray"));
                    filter_class.Add(new XElement("SearchBoth", true));
                    filter_class.Add(new XElement("ExSearchBoth", true));
                    filter_class.Add(new XElement("MoveFrom", false));
                    filter_class.Add(new XElement("SetMark", true));
                    filter_class.Add(new XElement("SearchUrl", false));
                    filter_class.Add(new XElement("ExSearchUrl", false));
                    filter_class.Add(new XElement("CaseSensitive", false));
                    filter_class.Add(new XElement("ExCaseSensitive", false));
                    filter_class.Add(new XElement("UseRegex", false));
                    filter_class.Add(new XElement("ExUseRegex", false));
                    filter_class.Add(new XElement("IsRt", false));
                    filter_class.Add(new XElement("IsExRt", false));
                    filter_class.Add(new XElement("Source"));
                    filter_class.Add(new XElement("ExSource"));
                }
                tab.Add(new XElement("TabName", node.Text));
                tab.Add(new XElement("TabType", "UserDefined"));
            }

            return doc;
        }

        private void button4_Click(object sender, EventArgs e)
        {
            var save = new SaveFileDialog();
            save.RestoreDirectory = true;
            save.Filter = "Tweenタブ設定ファイル|SettingTabs.xml";
            if (save.ShowDialog() != DialogResult.OK)
            {
                return;
            }
            var doc = CreateXml();

            var backuppath = save.FileName + ".old";
            MakeBackup(save.FileName, backuppath);

            if (cbOverwrite.Checked)
            {
                doc.Save(save.FileName);
            }
            else
            {
                Merge(save.FileName, backuppath, doc);
            }
            MessageBox.Show("SettingTabs.xml に保存しました\nバックアップファイルを" + backuppath + " に保存しました");
        }

        private void Merge(string destfile, string backuppath, XDocument doc)
        {
            var olddoc = XDocument.Load(backuppath);
            var twitter_lists = doc.Element("SettingTabs").Element("Tabs").Elements("TabClass");
            var dest_lists = olddoc.Element("SettingTabs").Element("Tabs").Elements("TabClass");
            foreach (var item in dest_lists)
	        {
                if (item.Element("TabType").Value != "UserDefined")
                {
                    continue;
                }
                var target_tab = twitter_lists.FirstOrDefault(v => v.Element("TabName").Value == item.Element("TabName").Value);
                if (target_tab == null)
                {
                    continue;
                }
                MergeTab(item, target_tab);
	        }

            foreach (var item in twitter_lists)
            {
                if (item.Element("TabType").Value != "UserDefined")
                {
                    continue;
                }
                var target_tab = dest_lists.FirstOrDefault(v => v.Element("TabName").Value == item.Element("TabName").Value);
                if (target_tab == null)
                {
                    olddoc.Element("SettingTabs").Element("Tabs").Add(item);
                }
            }
            olddoc.Save(destfile);
        }

        private void MergeTab(XElement dest, XElement src)
        {
            //新リストで消えてるのは消す
            var remove_list = new List<XElement>();
            foreach (var item in dest.Element("FilterArray").Elements("FiltersClass"))
            {
                var target = src.Element("FilterArray").Elements("FiltersClass").FirstOrDefault(v => v.Element("NameFilter").Value == item.Element("NameFilter").Value);
                if (target == null)
                {
                    remove_list.Add(item);
                    continue;
                }
            }
            foreach (var item in remove_list)
            {
                item.Remove();
            }

            //増えてるのを足す
            foreach (var item in src.Element("FilterArray").Elements("FiltersClass"))
            {
                var target = dest.Element("FilterArray").Elements("FiltersClass").FirstOrDefault(v => v.Element("NameFilter").Value == item.Element("NameFilter").Value);
                if (target == null)
                {
                    dest.Element("FilterArray").Add(item);
                }
            }
        }

        private void MakeBackup(string filepath, string backuppath)
        {
            var backupfile = new FileInfo(backuppath);
            if (backupfile.Exists)
            {
                backupfile.Delete();
            }
            File.Move(filepath, backupfile.FullName);
        }

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            backgroundWorker1.ReportProgress(0);
            try
            {
                Invoke(new Action(() => treeView1.Nodes.Clear()));

                var twitter = new TwitterLib(
                        Program.CONSUMER_KEY,
                        Program.CONSUMER_SECRET,
                        AccessToken,
                        AccessTokenSecret,
                        UserName,
                        "");

                var res = twitter.GetWebResponse("http://api.twitter.com/1/" + UserName + "/lists.xml");
                XDocument doc;
                using (var r = res.GetResponseStream())
                using (var rr = XmlReader.Create(r))
                {
                    doc = XDocument.Load(rr);
                }
                foreach (var item in doc.Element("lists_list").Element("lists").Elements("list"))
                {
                    Invoke(new Action(() => treeView1.Nodes.Add(item.Element("slug").Value)));
                }

                foreach (TreeNode item in treeView1.Nodes)
                {
                    string cursor = "";
                    do
                    {
                        string uri = "http://api.twitter.com/1/" + UserName + "/" + item.Text + "/members.xml";
                        var param = new Dictionary<string, string>();
                        if (!string.IsNullOrEmpty(cursor))
                        {
                            param.Add("cursor", cursor.ToString());
                        }

                        var isProced = false;
                        while (!isProced)
                        {
                            try
                            {
                                doc = DonwLoadXmlProc(twitter, uri, false, param);
                                isProced = true;
                            }
                            catch (Exception exx)
                            {
                                if (MessageBox.Show(exx.Message, "Web Error", MessageBoxButtons.RetryCancel) == System.Windows.Forms.DialogResult.Cancel)
                                {
                                    throw exx;
                                }
                            }
                        }

                        foreach (var item2 in doc.Element("users_list").Element("users").Elements("user"))
                        {
                            Invoke(new Action(() => item.Nodes.Add(item2.Element("screen_name").Value)));
                        }
                        cursor = doc.Root.Element("next_cursor").Value;
                    } while (cursor != "0");
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
            backgroundWorker1.ReportProgress(100);
        }

        private XDocument DonwLoadXmlProc(TwitterLib twitter, string uri, bool p, Dictionary<string, string> param)
        {
            var res = twitter.GetWebResponse(uri, false, param);
            using (var r = res.GetResponseStream())
            using (var rr = XmlReader.Create(r))
            {
                return XDocument.Load(rr);
            }
        }

        private void backgroundWorker1_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            if (e.ProgressPercentage == 0)
            {
                progressBar1.Style = ProgressBarStyle.Marquee;
                return;
            }
            progressBar1.Style = ProgressBarStyle.Continuous;
            progressBar1.Value = e.ProgressPercentage;
        }

        private void button5_Click(object sender, EventArgs e)
        {
            var f = new TwitterOAuthForm(Program.CONSUMER_KEY, Program.CONSUMER_SECRET);
            f.UserName = UserName;
            f.AccessToken = AccessToken;
            f.AccessTokenSecret = AccessTokenSecret;
            if (f.ShowDialog() == DialogResult.OK)
            {
                Properties.Settings.Default.UserName = f.UserName;
                Properties.Settings.Default.AccessToken = f.AccessToken;
                Properties.Settings.Default.AccessTokenSecret = f.AccessTokenSecret;
                Properties.Settings.Default.Save();
            }
        }

        private void MainForm_Shown(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(Properties.Settings.Default.AccessTokenSecret))
            {
                button5_Click(null, null);
            }
        }
    }
}
