﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.IO;

namespace Twitter
{
    class TwitterLib : Twitter.Auth
    {
        public TwitterLib(string consumerKey, string consumerSecret)
            :base(consumerKey, consumerSecret)
        {
        }

        public TwitterLib(string consumerKey, string consumerSecret, string accessToken, string accessTokenSecret, string userId, string screenName)
            :base(consumerKey, consumerSecret, accessToken, accessTokenSecret, userId, screenName)
        {
        }

        public string Post(string url)
        {
            var p = new Dictionary<string, string>();
            return base.Post(url, p);
        }

        protected SortedDictionary<string,string> CreateRequestData(string url, bool isPost, Dictionary<string, string> parameters)
        {
            SortedDictionary<string, string> parameters2 = GenerateParameters(AccessToken);
            if (parameters != null)
            {
                foreach (var p in parameters)
                    parameters2.Add(p.Key, p.Value);
            }
            string signature = GenerateSignature(AccessTokenSecret, isPost ? "POST" : "GET", url, parameters2);
            parameters2.Add("oauth_signature", UrlEncode(signature));
            return parameters2;
        }

        public WebResponse GetWebResponse(string url)
        {
            return GetWebResponse(url, false);
        }

        public WebResponse GetWebResponse(string url, bool isPost)
        {
            return GetWebResponse(url, isPost, null);
        }

        public WebResponse GetWebResponse(string url, bool isPost, Dictionary<string, string> parameters)
        {
            if (isPost)
            {
                byte[] data = Encoding.ASCII.GetBytes(JoinParameters(CreateRequestData(url, isPost, parameters)));
                WebRequest req = WebRequest.Create(url);
                req.Method = "POST";
                req.ContentType = "application/x-www-form-urlencoded";
                req.ContentLength = data.Length;
                using (Stream reqStream = req.GetRequestStream())
                {
                    reqStream.Write(data, 0, data.Length);
                }
                return req.GetResponse();
            }
            else
            {
                //Get Type
                WebRequest req = WebRequest.Create(url + '?' + JoinParameters(CreateRequestData(url, isPost, parameters)));
                return req.GetResponse();
            }
        }
    }
}
