﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Twitter;
using System.Diagnostics;

namespace Twitter
{
    public partial class TwitterOAuthForm : Form
    {
        public TwitterOAuthForm(string consumer_key, string consumer_secret)
        {
            this.consumer_key = consumer_key;
            this.consumer_secret = consumer_secret;
            InitializeComponent();
        }

        private readonly string consumer_key;
        private readonly string consumer_secret;

        private void btClearToken_Click(object sender, EventArgs e)
        {
            txtAccessToken.Clear();
            txtAccessTokenSecret.Clear();
        }

        TwitterLib twitter;

        private void btGetToken_Click(object sender, EventArgs e)
        {
            twitter.GetAccessToken(txtPass.Text);
            txtAccessToken.Text = twitter.AccessToken;
            txtAccessTokenSecret.Text = twitter.AccessTokenSecret;
        }

        public string AccessToken
        {
            get
            {
                return txtAccessToken.Text;
            }
            set
            {
                txtAccessToken.Text = value;
            }
        }
        public string AccessTokenSecret
        {
            get
            {
                return txtAccessTokenSecret.Text;
            }
            set
            {
                txtAccessTokenSecret.Text = value;
            }
        }
        public string UserName
        {
            get
            {
                return txtUser.Text;
            }
            set
            {
                txtUser.Text = value;
            }
        }

        private void txtPass_TextChanged(object sender, EventArgs e)
        {
            btGetToken.Enabled = (twitter != null) && !string.IsNullOrEmpty(txtPass.Text);
        }

        private void btGetPin_Click(object sender, EventArgs e)
        {
            twitter = new TwitterLib(
                    consumer_key,
                    consumer_secret,
                    AccessToken,
                    AccessTokenSecret,
                    UserName,
                    "");
            twitter.GetRequestToken();
            Process.Start(twitter.GetAuthorizeUrl());
            txtPass.ReadOnly = false;
        }

        private void btSave_Click(object sender, EventArgs e)
        {
            DialogResult = System.Windows.Forms.DialogResult.OK;
            Close();
        }
    }
}
