#!/usr/bin/env python
import sys
from PyQt4 import QtCore, QtGui, uic

form_class, base_class = uic.loadUiType("configDialog.ui")
class TwitturnConfigDialog(base_class, form_class):
    def __init__(self, *args):
        base_class.__init__(self, *args)

        self.setupUi(self)

        self.settings = QtCore.QSettings("Twitturn")
        self.connectActions()

        self.loadSettings()

    def connectActions(self):
        self.connect(
                self.toolButtonIconCacheDirecotry,
                QtCore.SIGNAL("pressed()"),
                self.getIconCacheDirecotry)
    def getIconCacheDirecotry(self):
        iconCacheDirecotry = QtGui.QFileDialog.getExistingDirectory(
                self,
                self.tr("Select Directory"),
                self.lineEditIconCacheDirecotry.text())
        if not iconCacheDirecotry.isEmpty():
            if not iconCacheDirecotry.endsWith('/'):
                iconCacheDirecotry = iconCacheDirecotry + '/'
            self.lineEditIconCacheDirecotry.setText(iconCacheDirecotry)

    def accept(self):
        base_class.accept(self)
        self.saveSettings()


    def loadSettings(self):
        if not self.settings.contains("configured"): return
        self.settings.beginGroup("twitter")
        self.lineEditUser.setText(
                self.settings.value("user").toString())
        self.lineEditPassword.setText(
                self.settings.value("password").toString())
        self.spinBoxInterval.setValue(
                self.settings.value("interval").toInt()[0])
        self.checkBoxFetchTimelineWhenPosting.setChecked(
                self.settings.value("fetchTimeLineWhenPosting").toBool())
        self.checkBoxFetchDMandRepliesOnStartup.setChecked(
                self.settings.value("fetchDMandRepliesOnStartup").toBool())
        self.radioButtonGET.setChecked(
                self.settings.value("useGETMethod").toBool())
        self.settings.endGroup()

        self.settings.beginGroup("cache")
        self.checkBoxUseIconCache.setChecked(
                self.settings.value("useIconCache").toBool())
        self.groupBoxIconCache.setEnabled(
                self.checkBoxUseIconCache.isChecked())
        self.lineEditIconCacheDirecotry.setText(
                self.settings.value("iconCacheDirecotry").toString())
        self.settings.endGroup()

        self.settings.beginGroup("proxy")
        self.checkBoxUseProxy.setChecked(
                self.settings.value("useProxy").toBool())
        self.lineEditProxyServer.setText(
                self.settings.value("server").toString())
        self.spinBoxProxyPort.setValue(
                self.settings.value("port").toInt()[0])
        self.settings.endGroup()

    def saveSettings(self):
        self.settings.setValue("configured", QtCore.QVariant(True))
        self.settings.beginGroup("twitter")
        self.settings.setValue("user",
                QtCore.QVariant(self.lineEditUser.text()))
        self.settings.setValue("password",
                QtCore.QVariant(self.lineEditPassword.text()))
        self.settings.setValue("interval",
                QtCore.QVariant(self.spinBoxInterval.value()))
        self.settings.setValue("fetchTimeLineWhenPosting",
                QtCore.QVariant(
                    self.checkBoxFetchTimelineWhenPosting.isChecked()))
        self.settings.setValue("fetchDMandRepliesOnStartup",
                QtCore.QVariant(
                    self.checkBoxFetchDMandRepliesOnStartup.isChecked()))
        self.settings.setValue("useGETMethod",
                QtCore.QVariant(self.radioButtonGET.isChecked()))
        self.settings.endGroup()

        self.settings.beginGroup("cache")
        self.settings.setValue("useIconCache",
                QtCore.QVariant(self.checkBoxUseIconCache.isChecked()))
        self.settings.setValue("iconCacheDirecotry",
                QtCore.QVariant(self.lineEditIconCacheDirecotry.text()))
        self.settings.endGroup()

        self.settings.beginGroup("proxy")
        self.settings.setValue("useProxy",
                QtCore.QVariant(self.checkBoxUseProxy.isChecked()))
        self.settings.setValue("server",
                QtCore.QVariant(self.lineEditProxyServer.text()))
        self.settings.setValue("port",
                QtCore.QVariant(self.spinBoxProxyPort.value()))
        self.settings.endGroup()



if __name__=="__main__":
    app = QtGui.QApplication(sys.argv)
    form = TwitturnConfigDialog()
    form.show()
    app.exec_()
