from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtNetwork import *
try:
    from xml.etree import ElementTree
except:
    from elementtree import ElementTree


yahooApplicationId = 'Z3JQ8CCxg675BqtSvimrBIo_CCXnQlQcYjgKPRDNuMZlIJyS5mdD9yqg2ESQp1uuNGM-'
timeoutSec = 30

class HotWordExtractor(QHttp):
    def __init__(self, parent=None):
        QHttp.__init__(self, parent)
        self.url = QUrl()
        self.setHost('jlp.yahooapis.jp')
        self.url.setQueryDelimiters("=","&")
        self.timer = QTimer(self)
        self.timer.setSingleShot(True)
        self.timer.setInterval(timeoutSec*1000)
        self.connect(self.timer, SIGNAL("timeout()"), self.abort)
        self.connect(self, SIGNAL("done(bool)"), self.done)
    def abort(self):
        print "HotWordExtractor: timeout"
        return QHttp.abort(self)

    def done(self, error):
        self.url.clear()
        self.timer.stop()
        if not error and self.lastResponse().statusCode() == 200:
            self.parse()
            self.emit(SIGNAL("parseDone"))
        else:
            print self.errorString()
            print self.lastResponse().toString()
#
# Sample request URL:
#
# http://jlp.yahooapis.jp/MAService/V1/parse?appid=<$B$"$J$?$N%"%W%j%1!<%7%g%s(BID>&results=ma,uniq&uniq_filter=9|10&sentence=%E5%BA%AD%E3%81%AB%E3%81%AF%E4%BA%8C%E7%BE%BD%E3%83%8B%E3%83%AF%E3%83%88%E3%83%AA%E3%81%8C%E3%81%84%E3%82%8B%E3%80%82
    def query(self, sentence):
        self.url.setPath('/MAService/V1/parse')
        queryItems = {
                'appid': yahooApplicationId,
                'response': 'surface',
                'results': 'uniq',
                'filter': '9',
                'sentence': str(QUrl.toPercentEncoding(sentence)),
                }
        for k, v in queryItems.iteritems():
            self.url.addQueryItem(k,v)
        self.get()
    def get(self):
        self.timer.start()
        return QHttp.get(self, self.url.toString())
    def post(self):
        self.timer.start()
        return QHttp.post(self, self.url.toString(), QByteArray())
    def parse(self):
        byteArray = self.readAll()
        str = QString(byteArray)
        if str == "":
            return None
        try:
            root = ElementTree.fromstring(str.toAscii())
        except:
            print str.toAscii()
            return None
        words = []
        for elm in root.findall('.//{urn:yahoo:jp:jlp}word'):
            words.append( 
                    ( int(elm.findtext('{urn:yahoo:jp:jlp}count')), elm.findtext('{urn:yahoo:jp:jlp}surface')))
        self.emit(SIGNAL("ready"), words)
