from PyQt4.QtCore import *
from PyQt4.QtGui import *
from extractionConfigDialog import *
from hotWordExtractor import *

class ExtractionTabFilter():
    def __init__(self, form, timeLineWidget):
        self.form = form
        self.timeLineWidget = timeLineWidget

        self.postBuffer = []

        self.rxURL = QRegExp("(https?:\/\/[-_.!~*'()a-zA-Z0-9;/?:&=+$,%#]+)")
        self.rxReply = QRegExp("@([a-zA-Z0-9_]+)")
        self.textExt = []
        self.textMatchingType = 1
        self.textCaseSesnsitivity = Qt.CaseInsensitive

        self.NGExt = []
        self.NGMatchingType = 1
        self.NGCaseSesnsitivity = Qt.CaseInsensitive

        self.hilight = False
        self.notify = False

        self.settings = QSettings("Twitturn")
        self.loadSettings()

        self.hotWordExtractor = HotWordExtractor()
        timeLineWidget.connect(self.hotWordExtractor, SIGNAL("ready"),
                self.updateFilter)

        self.filterSlots = []
        for i in range(3):
            self.filterSlots.append([])


        self.labelHotKeyWords = QLabel(form)
        self.labelHotKeyWords.setContentsMargins(4,0,0,0)
        self.form.statusBar().addWidget(self.labelHotKeyWords)

    def filter(self, post):
        dt=QDateTime.currentDateTime()
        dt = dt.addSecs(-20*60)
        v =  dt.toLocalTime().toString("yyyy/MM/dd hh:mm:ss")
        if v < post.text(3) :
            self.postBuffer.append(post)
            if 20 < len(self.postBuffer):
                str = ""
                for post in self.postBuffer:
                    str += post.text(2).remove(self.rxURL).remove(self.rxReply) + '\n'
                self.hotWordExtractor.query(str)
                del self.postBuffer[:]


        for text in self.textExt:
            if stringCompare(
                    QString(post.text(2)),
                    text, 
                    self.textMatchingType,
                    self.textCaseSesnsitivity):
                if self.timeLineWidget.addPost(post, True):
                    self.timeLineWidget.setNotify(True)
                    if self.hilight:
                        post.setForeground(
                                1, QBrush(QColor("darkgreen")))
                        post.setForeground(
                                2, QBrush(QColor("darkgreen")))
                    if self.notify:
                        self.form.systemTrayIconMessageDictionary[
                                post.text(4)
                                ] = ( post.text(1) + ": " + post.text(2))
                return

    def updateFilter(self, words):
        del self.textExt[:]

        filterWords = []
        for word in words:
            if 2 < word[0]:
                appendFlag = True
                for NG in self.NGExt:
                    if stringCompare(
                            QString(word[1]),
                            NG,
                            self.NGMatchingType,
                            self.NGCaseSesnsitivity):
                        appendFlag = False
                        print word[1], NG.toLocal8Bit()
                        break
                if appendFlag: 
                    filterWords.append(word[1])


        self.filterSlots.append(filterWords)
        for slot in self.filterSlots:
            for word in slot:
                self.textExt.append(word)
        self.filterSlots.pop(0)

        str = QString()
        for word in self.textExt:
            str += word + " "
        self.labelHotKeyWords.setText("HOT: "+ str)

    def loadSettings(self):
        if not self.settings.value("plugins/hotTab/configured").toBool(): 
            return
        self.settings.beginGroup('plugins/hotTab')
        self.NGMatchingType = self.settings.value("comboBoxNG").toInt()[0]
        if self.settings.value("checkBoxNG").toBool():
            self.NGCaseSesnsitivity = Qt.CaseSensitive
        else:
            self.NGCaseSesnsitivity = Qt.CaseInsensitive
        self.NGExt = self.settings.value("textEditNG").toString().split(
                "\n", 
                QString.SkipEmptyParts)
        self.notify = self.settings.value('checkBoxNotify').toBool()
        self.hilight = self.settings.value('checkBoxHilght').toBool()
        self.settings.endGroup()

def stringCompare(s1, s2, matchingType=0, cs=Qt.CaseInsensitive):
    if matchingType==0:
        return s1 == s2
    elif matchingType==1:
        return s1.contains(s2, cs)
    elif matchingType == 2:
        return s1.startsWith(s2, cs)
    elif matchingType == 3:
        return s1.endsWith(s2, cs)
    elif matchingType == 4:
        return QRegExp(s2,cs,QRegExp.RegExp2).exactMatch(s1)
    elif matchingType == 5:
        return QRegExp(s2,cs,QRegExp.Wildcard).exactMatch(s1)

