#!/usr/bin/env python

import sys, os, re

from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtNetwork import *

from ticker import IpcOutputClient

import signal
signal.signal(signal.SIGINT, signal.SIG_DFL)

class IpcOutputClientGUI2(QWidget, IpcOutputClient):
    def __init__(self, parent=None):
        QWidget.__init__(self, parent)
        IpcOutputClient.__init__(self, self)
        self.tweetsQueue = []

        self.dragPosition = QPoint()

        quitAction = QAction(self.tr("E&xit"), self)
        quitAction.setShortcut(self.tr("Ctrl+Q"))
        quitAction.triggered.connect(app.quit)
        self.addAction(quitAction)
        self.setContextMenuPolicy(Qt.ActionsContextMenu)

        self.indicatorRect = QRect(3,3,5,5)

        self.displayString = ""
        self.displayStringPosition = 0
        self.displayStringBoundRect = QRect(
                10,
                2,
                self.width() - 15,
                self.height() - 4
                )
        self.timer = QBasicTimer()

    def paintEvent(self, event):
        QWidget.paintEvent(self, event)

        p = QPainter(self)
        p.setRenderHint(QPainter.Antialiasing)

        p.fillRect(self.rect(), Qt.transparent)

        p.setPen( QPen( Qt.black, 1, Qt.SolidLine))
        p.setBrush( QColor(0,0,0,86))
        p.drawRoundedRect(self.rect(), 5, 5)

        if self.sock.state() == QAbstractSocket.ConnectedState:
            paintActiveIndicator(p, self.indicatorRect)
        else:
            paintEnactiveIndicator(p, self.indicatorRect)
            pass

        if self.shouldTextScroll():
            paintText(
                    p,
                    self.displayString, 
                    self.displayStringBoundRect,
                    self.displayStringPosition
                    )
            if 25 < self.displayStringPosition%30 < 30:
                paintBlinkingIndicator(p, self.indicatorRect)

        p.end()

    def shouldTextScroll(self):
        if 0 < len(self.displayString):
            if self.displayStringPosition < self.fontMetrics().width( self.displayString):
                return True

        return False

    def timerEvent(self, event):
        if event.timerId() == self.timer.timerId():
            self.update()
            self.displayStringPosition += 1
            if not self.shouldTextScroll():
                self.timer.stop()
                self.tickerNext()
        else:
            QWidget.timerEvent()
        pass

    def mousePressEvent(self, event):
        if event.button() == Qt.LeftButton:
            self.dragPosition = event.globalPos() - self.frameGeometry().topLeft()
            event.accept()
    def mouseMoveEvent(self, event):
        if event.buttons() & Qt.LeftButton:
            self.move(event.globalPos() - self.dragPosition)
            event.accept()

    def slotConnected(self):
        self.repaint(self.indicatorRect)
        pass
    def slotDisconnected(self):
        self.repaint(self.indicatorRect)
        pass

    def read(self):
        self.tweetsQueue.append(
                QString.fromUtf8( self.sock.readAll()).replace( '\n' , '        '))

        if not self.timer.isActive():
            self.tickerNext()
            pass

    def tickerNext(self):
        if 0 < len(self.tweetsQueue):
            text = self.tweetsQueue.pop(0) 
            self.displayString = text
            self.displayStringPosition = -self.width()
            self.displayStringBoundRect.setWidth(
                self.fontMetrics().width( 
                    self.displayString))
            self.timer.start(20, self)

def paintEnactiveIndicator(p, rect):
    p.setPen( QPen( Qt.black, 1, Qt.SolidLine))
    p.setBrush(Qt.red)
    p.drawEllipse(rect)
    pass
def paintActiveIndicator(p, rect):
    p.setPen( QPen( Qt.black, 1, Qt.SolidLine))
    p.setBrush(Qt.green)
    p.drawEllipse(rect)
    pass
def paintBlinkingIndicator(p, rect):
    p.setPen( QPen( Qt.black, 1, Qt.SolidLine))
    p.setBrush(Qt.black)
    p.drawEllipse(rect)
    pass

def paintText(p, text, rect, x):
    p.setPen(Qt.white)
    p.setBrush(Qt.white)
    p.drawText(
            QRect(
                rect.x() - x,
                rect.y(),
                rect.width(),
                rect.height()
                ),
            Qt.AlignLeft,
            text
            )
    pass


if __name__=="__main__":
    app = QApplication(sys.argv)
    client = IpcOutputClientGUI2()
    client.setAttribute( Qt.WA_TranslucentBackground) 
    client.setWindowFlags( Qt.ToolTip
            | Qt.FramelessWindowHint
            | Qt.WindowStaysOnTopHint
            | Qt.WindowSystemMenuHint
            )

    USAGE = """Usage: %s [options] keyword
    Options:
        -h, --help                      show this help message and exit
        -geometry [WxH][-/+X-/+Y]       size and position
    """ % sys.argv[0] 
    WIDTH = 400
    HEIGHT = 20

    if '-h' in sys.argv or '--help' in sys.argv:
        print USAGE
        sys.exit(-1)
    if '-geometry' in sys.argv:
        geomIndex = sys.argv.index('-geometry') + 1
        if geomIndex < len(sys.argv):
            p = re.compile('^((\d+)x(\d+))?(([+-])(\d+)([+-])(\d+))?$')
            m = p.match(sys.argv[geomIndex])
            if m:
                if m.group(1):
                    client.resize(int(m.group(2)), int(m.group(3)))
                else:
                    client.resize(WIDTH,HEIGHT)
                if m.group(4): 
                    x = int(m.group(6))
                    y = int(m.group(8))
                    rec = QDesktopWidget().screenGeometry()
                    if m.group(5) == '-':
                        x = rec.width() - (client.width() + x)
                    if m.group(7) == '-':
                        y = rec.height() - (client.height() + y)
                    client.move(x, y)
            else:
                print USAGE
                sys.exit(-1)
        else:
            print USAGE
            sys.exit(-1)
    else:
        client.resize(WIDTH,HEIGHT)
    client.show()
    sys.exit(app.exec_())
