using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Xml;
using System.IO;
using Plugin;

namespace DetailLogPlugin
{
    public class DetailLogViewer
    {
        // <^O,^Oo^Ăڍ׃O>
        Dictionary<string, List<DetailLogInfo>> tag_log;

        // <t,tɈvڍ׃O>
        Dictionary<string, List<DetailLogInfo>> date_log;

        public const string DATE_FORMAT = "yyyyNMMdd";
        public const string TIME_FORMAT = "HH:mm";

        #region vpeB...
        public List<string> TagList
        {
            get { return new List<string>(tag_log.Keys); }
        }
        public List<string> DateList
        {
            get { return new List<string>(date_log.Keys); }
        }
        #endregion

        public DetailLogViewer()
        {
            tag_log = new Dictionary<string, List<DetailLogInfo>>();
            date_log = new Dictionary<string, List<DetailLogInfo>>();
        }

        /// <summary>
        /// w肳ꂽtɍ쐬ꂽڍ׃O̐Ԃ
        /// </summary>
        /// <param name="date"></param>
        /// <returns></returns>
        public int GetDateSetNum(string date)
        {
            return date_log[date].Count;
        }

        /// <summary>
        /// w肳ꂽ^Otꂽڍ׃O̐Ԃ
        /// </summary>
        /// <param name="tag"></param>
        /// <returns></returns>
        public int GetTagSetNum(string tag)
        {
            return tag_log[tag].Count;
        }

        public List<DetailLogInfo> GetDateInfo(string date)
        {
            return date_log[date];
        }

        public List<DetailLogInfo> GetTagInfo(string tag)
        {
            return tag_log[tag];
        }

        /// <summary>
        /// ڍ׃OfBNgɂ邷ׂĂ̏ڍ׃Ȍ擾
        /// </summary>
        public void LoadInfo()
        {
            string plugin_dir = Path.Combine(LogDir.LOG_DIR, DetailLog.PLUGIN_NAME);
            string [] files = Directory.GetFiles(plugin_dir, "*.xml");

            tag_log.Clear();
            date_log.Clear();

            foreach (string path in files)
            {
                Console.WriteLine(path);
                DetailLogInfo info = new DetailLogInfo();
                info.FileName = path;

                FileStream fs = new FileStream(path,
                    FileMode.Open, FileAccess.Read, FileShare.Read);
                XmlTextReader reader = new XmlTextReader(fs);
                try
                {
                    bool b_tag = false;
                    bool b_comment = false;
                    bool b_date = false;
                    bool b_finish = false;
                    while (reader.Read() && !b_finish)
                    {
                        switch (reader.NodeType)
                        {
                            case XmlNodeType.Element:
                                if (reader.Name == "Tag")
                                {
                                    b_tag = true;
                                }
                                else if (reader.Name == "Comment")
                                {
                                    b_tag = false;
                                    b_comment = true;
                                }
                                else if (reader.Name == "Date")
                                {
                                    b_comment = false;
                                    b_date = true;
                                }
                                /*
                                if (reader.MoveToFirstAttribute())
                                {
                                    do
                                    {
                                        Console.WriteLine(string.Format("𔭌 {0}={1}", reader.Name, reader.Value));
                                    } while (reader.MoveToNextAttribute());
                                }
                                */
                                break;
                            case XmlNodeType.Text:
                                if (b_tag)
                                {
                                    b_tag = false;
                                    info.Tag.AddRange(reader.Value.Split(new char[] { ',' }));
                                }
                                if (b_comment)
                                {
                                    b_comment = false;
                                    info.Comment = reader.Value;
                                }
                                if (b_date)
                                {
                                    b_date = false;
                                    info.Date = DateTime.Parse(reader.Value);
                                    b_finish = true;
                                }
                                break;
                        }
                    }
                }
                finally
                {
                    fs.Close();
                    reader.Close();
                }

                foreach (string tag in info.Tag)
                {
                    if(!tag_log.ContainsKey(tag)){
                        tag_log[tag] = new List<DetailLogInfo>();
                    }
                    tag_log[tag].Add(info);
                }
                string date = info.Date.ToString(DATE_FORMAT);
                if (!date_log.ContainsKey(date))
                {
                    date_log[date] = new List<DetailLogInfo>();
                }
                date_log[date].Add(info);

                /*
                foreach (string tag in TagList)
                {
                    Console.Write(tag + ",");
                }
                Console.Write("\n");
                Console.WriteLine(info.Comment);
                Console.WriteLine(info.Date.ToString());
                 * */
            }
        }
    }
}
