using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

namespace TypingManager
{
    /// <summary>
    /// ̑ŌxvZ
    /// </summary>
    public class TypingSpeed
    {
        /// <summary>ŌxvZ邽߂̃Tvێ鐔</summary>
        const int SAMPLE_MAX = 256;

        /// <summary>ftHg̕ϑŌԊu[msec]</summary>
        const uint DEFAULT_AVERAGE_TIME = 1000;

        /// <summary>ŌxZo邽߂ɗpTv</summary>
        private int sample_num;

        /// <summary>Ō[msec]1ŌƂɋL^f[^</summary>
        private List<uint> sample_data;

        /// <summary>Ōx[stroke/min]1bɋL^f[^</summary>
        private List<float> speed_per_sec;

        /// <summary>1Ō̕ϑŌԊu[sec]</summary>
        private float average_stroke_time = DEFAULT_AVERAGE_TIME;

        /// <summary>1b̑O̍Ō̑Ō[msec]</summary>
        private uint last_sample_data = 0;

        public TypingSpeed(int sample_num)
        {
            this.sample_num = sample_num;
            sample_data = new List<uint>(SAMPLE_MAX);
            speed_per_sec = new List<float>(SAMPLE_MAX);
            speed_per_sec.Add(0);
        }

        public void Stroke(uint mili_sec)
        {
            sample_data.Add(mili_sec);

            // TvƂĕێĂTCY̍őɒB擪폜
            if (sample_data.Count >= SAMPLE_MAX)
            {
                sample_data.RemoveRange(0, SAMPLE_MAX / 2);
            }
        }

        private void RecordAverageSpeed(float speed)
        {
            speed_per_sec.Add(speed);

            if (speed_per_sec.Count >= SAMPLE_MAX)
            {
                speed_per_sec.RemoveRange(0, SAMPLE_MAX / 2);
            }
        }

        /// <summary>
        /// PʎԂƂɎ擾ϑŌxzŎ擾
        /// </summary>
        /// <param name="start">0ŐVC傫ȂƌÂf[^</param>
        /// <param name="count"></param>
        /// <returns></returns>
        public float[] GetSpeedRange(int start, int count)
        {
            if (speed_per_sec.Count < count + start)
            {
                count = speed_per_sec.Count - start;
            }
            float[] result = new float[count];
            for (int i = 0; i < count; i++)
            {
                result[i] = speed_per_sec[speed_per_sec.Count - i - 1];
            }
            return result;
        }

        /// <summary>
        /// ߋsample_num̑Ō畽ϑŌxiŁ^jvZ
        /// </summary>
        /// <returns></returns>
        public float GetSpeed()
        {
            return speed_per_sec[speed_per_sec.Count - 1];
        }

        /// <summary>
        /// ݃^CsO
        /// </summary>
        /// <returns></returns>
        public bool IsTyping()
        {
            if (GetSpeed() == 0.0f)
            {
                return false;
            }
            return true;
        }

        public void SetLastSpeed(uint now)
        {
            int length = sample_data.Count;
            uint no_stroke_time = (uint)(average_stroke_time * 1000 * AppConfig.NoStrokeLimitTime);

            // no_stroke_timeႦ0.01bƂɂȂƐVŌĂ
            // Ō̑Ō獡̎Ԃ܂ł̍̕傫ȂĂ܂
            // ɉ̏藧sample_dataĂ܂
            // no_stroke_timeDEFAULTƂDEFAULTɐݒ肵Ȃ
            no_stroke_time = no_stroke_time < DEFAULT_AVERAGE_TIME ? DEFAULT_AVERAGE_TIME : no_stroke_time;
            
            if (length == 0 || now - sample_data[length - 1] > no_stroke_time)
            {
                // Ō̑Ōݒ肵Ԉȏo߂ŌȂ̂Ƃ
                RecordAverageSpeed(0);
                sample_data.Clear();
                return;
            }

            // ϑŌxZoɗpTv߂
            int sample = length < sample_num ? length : sample_num;
            
            uint diff_sum = now - sample_data[length - sample];
            if (length == 1 && diff_sum <= DEFAULT_AVERAGE_TIME)
            {
                // 1ŌȂꍇőłĂDEFAULT_AVERAGE_TIMEo߂ĂȂꍇ
                diff_sum = DEFAULT_AVERAGE_TIME;
            }
            // OvZƂVȑŌĂȂꍇ͌vZȂ
            if (last_sample_data != sample_data[length - 1])
            {
                average_stroke_time = diff_sum / 1000.0f / sample;
                last_sample_data = sample_data[length - 1];
            }
            //Debug.WriteLine(string.Format("ϑŌԊuF{0:f3}sec", average_stroke_time));
            float average_speed = (float)sample / diff_sum * 1000 * 60;
            RecordAverageSpeed(average_speed);
            return;
        }
    }
}
