using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace Plugin
{
    public class NumSort : System.Collections.IComparer
    {
        private SortOrder sort_order = SortOrder.Ascending;	// \[g(E~)
        private int column = 0;	// \[g
        private List<int> num_column; // lŔr

        #region vpeB...
        public SortOrder Order
        {
            get { return sort_order; }
            set { sort_order = value; }
        }
        public int Column
        {
            get { return column; }
            set { column = value; }
        }
        #endregion

        public NumSort(params int[] list)
        {
            num_column = new List<int>(list);
        }
        // rʂԂ
        public int Compare(object x, object y)
        {
            int ret = 0;
            // rpXgACei[ϐ
            ListViewItem sx = (ListViewItem)x;
            ListViewItem sy = (ListViewItem)y;

            // rAli[
            if (num_column.Contains(column))
            {
                // ̏ĂȂcolumn͈͊OƓ{Ă܂Ƃ
                // ČF
                // uڍ׃Ov^u̍̃Xgr[Łu2ȏ̍ځvIC
                // ẼXgr[2ڈȍ~̂ǂꂩ̗ɂă\[gs
                // ̃Xgr[́u2ȏ̍ځvI悤ƂƗD
                // FACe̒ǉ̎dɒ
                if (column < sx.SubItems.Count && column < sy.SubItems.Count)
                {
                    ret = int.Parse(sx.SubItems[column].Text) - int.Parse(sy.SubItems[column].Text);
                }
            }
            else
            {
                if (column < sx.SubItems.Count && column < sy.SubItems.Count)
                {
                    ret = string.Compare(sx.SubItems[column].Text, sy.SubItems[column].Text);
                }
            }

            // ~̂Ƃ͌ʂt]
            if (sort_order == SortOrder.Descending)
            {
                ret = -ret;
            }

            //ʂԂ
            return ret;
        }

        public void ChangeSortOrder()
        {
            if (Order == SortOrder.Descending)
            {
                Order = SortOrder.Ascending;
            }
            else
            {
                Order = SortOrder.Descending;
            }
        }
    }
}
