using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Diagnostics;

namespace TypingManager
{
    public class GaugeGraph : Graph
    {
        // L[̒ɓĂߋ̒l̐
        const int MAX_QUEUE = 1024;

        // Q[W̌
        const int GAUGE_NUM = 10;

        // Q[WƂ̗]
        const int GAUGE_MARGIN = 1;

        private float max;
        private float min;
        private List<float> values;

        #region vpeB
        public float Max
        {
            get { return max; }
            set { max = value; }
        }
        public float Min
        {
            get { return min; }
            set { min = value; }
        }
        #endregion

        public GaugeGraph(int width, int height, Rect rect)
            : base(width, height, rect)
        {
            Init();
        }

        public GaugeGraph(int width, int height)
            : base(width, height)
        {
            Init();
        }

        private void Init()
        {
            min = 0f;
            max = 1000f;
            values = new List<float>(MAX_QUEUE);
        }

        public void SetValue(float value)
        {
            values.Add(value);
            
            // TvƂĕێĂTCY̍őɒB擪폜
            if (values.Count >= MAX_QUEUE)
            {
                values.RemoveRange(0, MAX_QUEUE / 2);
            }
        }

        public int GaugeNum(float value)
        {
            // maxmin̒ō̒l͉ɂȂĂ邩𒲂ׂ
            float percent = 0;
            if (value > min)
            {
                percent = (float)(value - min) / (max - min);
            }

            // UQ[W̒ŉڂ܂ŒBĂ邩
            int gauge_value = (int)(GAUGE_NUM * percent);
            if (gauge_value > GAUGE_NUM)
            {
                gauge_value = GAUGE_NUM;
            }
            return gauge_value;
        }

        private int GetGaugeHeight()
        {
            // `ł͈͂draw_rect
            int drawable_height = DrawRect.Height - GAUGE_MARGIN * (GAUGE_NUM - 1);
            if (drawable_height < GAUGE_NUM)
            {
                drawable_height = DrawRect.Height;
            }
            // ̃Q[W̍
            int gauge_height = drawable_height / GAUGE_NUM;
            //Debug.WriteLine("DrawRectHeight:{0}, DrawableHeight:{1}", DrawRect.Height, drawable_height);
            return gauge_height;
        }

        private void DrawGauges(Graphics g, Brush brush, int gauge_value)
        {
            int gauge_height = GetGaugeHeight();
            
            for (int i = 0; i < gauge_value; i++)
            {
                g.FillRectangle(brush, DrawRect.Left,
                    DrawRect.Top + gauge_height * (GAUGE_NUM - i) + GAUGE_MARGIN * (GAUGE_NUM - i),
                    DrawRect.Width, gauge_height);
            }
        }

        public override void DrawFrame()
        {
            // bmpɐݒ肳ĂC[WGraphicsIuWFNg擾
            Graphics g = Graphics.FromImage(Bmp);
            g.FillRectangle(Brushes.Black, 0, 0, Bmp.Width, Bmp.Height);

            float now = values[values.Count-1];
            int gauge_value = GaugeNum(now);
            DrawGauges(g, Brushes.Green, GAUGE_NUM);
            DrawGauges(g, Brushes.Lime, gauge_value);
            
            //Graphicsj
            g.Dispose();
        }
    }
}
