using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Threading;
using System.Diagnostics;
using System.ComponentModel;
using System.Windows.Forms;

namespace TypingManager
{
    public interface IKeyboardHookBase : IDisposable
    {
        event KeyboardHookedEventHandler KeyboardHooked;
    }

    ///<summary>L[{[h삳ꂽƂɎs郁\bh\CxgnhB</summary>
    public delegate void KeyboardHookedEventHandler(object sender, KeyboardHookedEventArgs e);

    ///<summary>KeyboardHookedCxg̃f[^񋟂B</summary>
    public class KeyboardHookedEventArgs : CancelEventArgs
    {
        ///<summary>VCX^X쐬B</summary>
        internal KeyboardHookedEventArgs(KeyboardMessage message, ref KeyboardState state)
        {
            this.message = message;
            this.state = state;
        }
        private KeyboardMessage message;
        private KeyboardState state;

        ///<summary>L[{[hꂽꂽ\l擾B</summary>
        public KeyboardUpDown UpDown
        {
            get
            {
                return (message == KeyboardMessage.KeyDown || message == KeyboardMessage.SysKeyDown) ?
                    KeyboardUpDown.Down : KeyboardUpDown.Up;
            }
        }
        ///<summary>삳ꂽL[̉zL[R[h\l擾B</summary>
        public Keys KeyCode { get { return state.KeyCode; } }

        ///<summary>삳ꂽL[̃XLR[h\l擾B</summary>
        public int ScanCode { get { return state.ScanCode; } }

        ///<summary>삳ꂽL[eL[Ȃǂ̊gL[ǂ\l擾B</summary>
        public bool IsExtendedKey { get { return state.Flag.IsExtended; } }

        ///<summary>ALTL[Ă邩ǂ\l擾B</summary>
        public bool AltDown { get { return state.Flag.AltDown; } }
    }

    ///<summary>L[{[hĂ邩Ă邩\B</summary>
    public enum KeyboardUpDown
    {
        ///<summary>L[͉ĂB</summary>
        Down,
        ///<summary>L[͕ĂB</summary>
        Up,
    }

    ///<summary>bZ[WR[h\B</summary>
    internal enum KeyboardMessage
    {
        ///<summary>L[ꂽB</summary>
        KeyDown = 0x100,

        ///<summary>L[ꂽB</summary>
        KeyUp = 0x101,

        ///<summary>VXeL[ꂽB</summary>
        SysKeyDown = 0x104,

        ///<summary>VXeL[ꂽB</summary>
        SysKeyUp = 0x105,
    }

    ///<summary>L[{[h̏Ԃ\B</summary>
    internal struct KeyboardState
    {
        ///<summary>zL[R[hB</summary>
        public Keys KeyCode;

        ///<summary>XLR[hB</summary>
        public int ScanCode;

        ///<summary>etOB</summary>
        public KeyboardStateFlag Flag;

        ///<summary>̃bZ[WꂽƂ̎ԁB</summary>
        public int Time;

        ///<summary>bZ[WɊ֘AÂꂽgB</summary>
        public IntPtr ExtraInfo;
    }

    ///<summary>L[{[h̏Ԃ⑫B</summary>
    internal struct KeyboardStateFlag
    {
        private int flag;
        private bool IsFlagging(int value)
        {
            return (flag & value) != 0;
        }
        private void Flag(bool value, int digit)
        {
            flag = value ? (flag | digit) : (flag & ~digit);
        }

        ///<summary>L[eL[̃L[̂悤ȊgL[ǂ\B</summary>
        public bool IsExtended { get { return IsFlagging(0x01); } set { Flag(value, 0x01); } }

        ///<summary>CxgCWFNgꂽǂ\B</summary>
        public bool IsInjected { get { return IsFlagging(0x10); } set { Flag(value, 0x10); } }

        ///<summary>ALTL[Ă邩ǂ\B</summary>
        public bool AltDown { get { return IsFlagging(0x20); } set { Flag(value, 0x20); } }

        ///<summary>L[ꂽǂ\B</summary>
        public bool IsUp { get { return IsFlagging(0x80); } set { Flag(value, 0x80); } }
    }

    ///<summary>L[{[h̑tbNACӂ̃\bh}B</summary>
    [DefaultEvent("KeyboardHooked")]
    public class KeyboardHook : Component, IKeyboardHookBase
    {
        [DllImport("user32.dll", SetLastError = true)]
        private static extern IntPtr SetWindowsHookEx(int hookType, KeyboardHookDelegate hookDelegate, IntPtr hInstance, uint threadId);
        [DllImport("user32.dll", SetLastError = true)]
        private static extern int CallNextHookEx(IntPtr hook, int code, KeyboardMessage message, ref KeyboardState state);
        [DllImport("user32.dll", SetLastError = true)]
        private static extern bool UnhookWindowsHookEx(IntPtr hook);
        [DllImport("kernel32.dll", SetLastError = true)]
        public static extern IntPtr GetModuleHandle(string lpModuleName);

        private delegate int KeyboardHookDelegate(int code, KeyboardMessage message, ref KeyboardState state);
        private const int KeyboardHookType = 13; // WH_KEYBOARD_LL
        private GCHandle hookDelegate;
        private IntPtr hook;
        private static readonly object EventKeyboardHooked = new object();

        ///<summary>L[{[h삳ꂽƂɔB</summary>
        public event KeyboardHookedEventHandler KeyboardHooked
        {
            add { base.Events.AddHandler(EventKeyboardHooked, value); }
            remove { base.Events.RemoveHandler(EventKeyboardHooked, value); }
        }

        ///<summary>
        ///KeyboardHookedCxg𔭐B
        ///</summary>
        ///<param name="e">Cxg̃f[^B</param>
        protected virtual void OnKeyboardHooked(KeyboardHookedEventArgs e)
        {
            KeyboardHookedEventHandler handler = base.Events[EventKeyboardHooked] as KeyboardHookedEventHandler;
            if (handler != null)
                handler(this, e);
        }

        ///<summary>
        ///VCX^X쐬B
        ///</summary>
        public KeyboardHook()
        {
            if (Environment.OSVersion.Platform != PlatformID.Win32NT)
            {
                throw new PlatformNotSupportedException("Windows 98/Meł̓T|[gĂ܂B");
            }
            KeyboardHookDelegate callback = new KeyboardHookDelegate(CallNextHook);
            this.hookDelegate = GCHandle.Alloc(callback);
            IntPtr module = GetModuleHandle(Process.GetCurrentProcess().MainModule.ModuleName);
            this.hook = SetWindowsHookEx(KeyboardHookType, callback, module, 0);
            if (this.hook == IntPtr.Zero)
            {
                MessageBox.Show("SetWindowsHookEx Failed");
                return;
            }
        }

        ///<summary>
        ///L[{[h삳ꂽƂɎsfQ[gw肵ăCX^X쐬B
        ///</summary>
        ///<param name="handler">L[{[h삳ꂽƂɎs郁\bh\CxgnhB</param>
        public KeyboardHook(KeyboardHookedEventHandler handler)
            : this()
        {
            this.KeyboardHooked += handler;
        }
        private int CallNextHook(int code, KeyboardMessage message, ref KeyboardState state)
        {
            //Debug.WriteLine("CallNextHook()");
            if (code >= 0)
            {
                KeyboardHookedEventArgs e = new KeyboardHookedEventArgs(message, ref state);
                OnKeyboardHooked(e);
                if (e.Cancel)
                {
                    return -1;
                }
            }
            return CallNextHookEx(IntPtr.Zero, code, message, ref state);
        }

        ///<summary>
        ///gpĂA}l[W\[XAIvVŃ}l[W\[XB
        ///</summary>
        ///<param name="disposing">}l[W\[XꍇtrueB</param>
        protected override void Dispose(bool disposing)
        {
            if (this.hookDelegate.IsAllocated)
            {
                UnhookWindowsHookEx(hook);
                this.hook = IntPtr.Zero;
                this.hookDelegate.Free();
            }
            base.Dispose(disposing);
        }
    }
}
