﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading;
using System.Windows.Forms;

using HgCo.WindowsLive.SkyDrive;

namespace SkyDriveFolder
{
    public partial class FolderControl : UserControl
    {
        private const int ICON_INDEX_DRIVE_GLOBE = 0;
        private const int ICON_INDEX_FOLDER = 1;
        private const int ICON_INDEX_FOLDER_OPEN = 2;

        private SkyDriveModel _model;

        public FolderControl()
        {
            InitializeComponent();
        }

        public FolderControl(SkyDriveModel model)
            : this()
        {
            try
            {
                _model = model;

                TreeNode rootNode = new TreeNode(string.Format("SkyDrive ({0})", model.ID),
                    ICON_INDEX_DRIVE_GLOBE,
                    ICON_INDEX_DRIVE_GLOBE);
                rootNode.Tag = _model.RootFolder;
                rootNode.Nodes.Add(string.Empty);

                folderTree.Nodes.Add(rootNode);
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
                throw ex;
            }
        }

        public void Initialize()
        {
            try
            {
                TreeNode rootNode = folderTree.Nodes[0];
                folderTree.SelectedNode = rootNode;
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
                throw ex;
            }
        }

        private void folderTree_BeforeExpand(object sender, TreeViewCancelEventArgs e)
        {
            try
            {
                SkyDriveFolder folder = (SkyDriveFolder)e.Node.Tag;

                if (folder.LastRequestDateTime == null)
                {
                    this.Enabled = false;
                    e.Cancel = true;

                    Thread t = new Thread(new ParameterizedThreadStart(DoExpand));
                    t.Start(e.Node);
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
                throw ex;
            }
        }

        private void folderTree_BeforeSelect(object sender, TreeViewCancelEventArgs e)
        {
            try
            {
                SkyDriveFolder folder = (SkyDriveFolder)e.Node.Tag;

                if (folder.LastRequestDateTime == null)
                {
                    this.Enabled = false;

                    Thread t = new Thread(new ParameterizedThreadStart(DoOpenNode));
                    t.Start(e.Node);
                }
                else
                {
                    _model.OpenedFolder = folder;
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
                throw ex;
            }
        }

        private void DoExpand(object arg)
        {
            try
            {
                TreeNode node = (TreeNode)arg;
                SkyDriveFolder folder = (SkyDriveFolder)node.Tag;

                _model.RequestFolder(folder);

                this.Invoke(new MethodInvoker(delegate()
                {
                    try
                    {
                        folderTree.SuspendLayout();

                        node.Nodes.Clear();

                        foreach (SkyDriveFolder childFolder in folder.FolderList)
                        {
                            TreeNode childNode = new TreeNode(childFolder.Info.Name, ICON_INDEX_FOLDER, ICON_INDEX_FOLDER);
                            childNode.Tag = childFolder;
                            childNode.Nodes.Add(string.Empty);

                            node.Nodes.Add(childNode);
                        }

                        node.Expand();

                        folderTree.ResumeLayout();

                        this.Enabled = true;
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.ToString());
                        throw ex;
                    }
                }));
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
                throw ex;
            }
        }

        private void DoOpenNode(object arg)
        {
            try
            {
                TreeNode node = (TreeNode)arg;
                SkyDriveFolder folder = (SkyDriveFolder)node.Tag;

                _model.RequestFolder(folder);

                this.Invoke(new MethodInvoker(delegate()
                {
                    try
                    {
                        folderTree.SuspendLayout();

                        node.Nodes.Clear();

                        foreach (SkyDriveFolder childFolder in folder.FolderList)
                        {
                            TreeNode childNode = new TreeNode(childFolder.Info.Name, ICON_INDEX_FOLDER, ICON_INDEX_FOLDER);
                            childNode.Tag = childFolder;
                            childNode.Nodes.Add(string.Empty);

                            node.Nodes.Add(childNode);
                        }

                        node.Expand();

                        folderTree.ResumeLayout();

                        this.Enabled = true;

                        _model.OpenedFolder = folder;
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.ToString());
                        throw ex;
                    }
                }));
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
                throw ex;
            }
        }

        private void folderTree_DragDrop(object sender, DragEventArgs e)
        {
            string[] paths = (string[])e.Data.GetData(DataFormats.FileDrop, false);

            foreach (string path in paths)
            {
                Console.WriteLine("Path: {0}", path);
            }
        }

        private void folderTree_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(DataFormats.FileDrop, false))
            {
                e.Effect = DragDropEffects.Copy;
            }
        }
    }
}
