﻿using System;

namespace HgCo.WindowsLive.SkyDrive.Support
{
    /// <summary>
    /// Provides methods for handling enum <see cref="E:WebFolderItemShareType"/>.
    /// </summary>
    internal static class WebFolderItemShareTypeHelper
    {
        /// <summary>
        /// Parses the ShareType from a string.
        /// </summary>
        /// <param name="sharedWith">The ShareType text.</param>
        /// <returns>The parsed ShareType.</returns>
        public static WebFolderItemShareType ParseShareType(string sharedWith)
        {
            WebFolderItemShareType shareType = WebFolderItemShareType.None;
            if (!String.IsNullOrEmpty(sharedWith))
            switch(sharedWith.ToLower())
            {
                case "everyone (public)":
                    shareType = WebFolderItemShareType.Public; 
                    break;
                case "my network":
                    shareType = WebFolderItemShareType.MyNetwork;
                    break;
                case "people i selected":
                    shareType = WebFolderItemShareType.PeopleSelected;
                    break;
                case "just me":
                    shareType = WebFolderItemShareType.Private;
                    break;
            }
            return shareType;
        }
    }
}
