﻿using System;

namespace HgCo.WindowsLive.SkyDrive.Support
{
    /// <summary>
    /// Provides methods for handling enum <see cref="E:WebFolderViewType"/>.
    /// </summary>
    internal static class WebFolderViewTypeHelper
    {
        /// <summary>
        /// Parses the ViewType from a string.
        /// </summary>
        /// <param name="viewTypeText">The ViewType text.</param>
        /// <returns>The parsed ViewType.</returns>
        public static WebFolderViewType ParseViewType(string viewTypeText)
        {
            WebFolderViewType viewType = WebFolderViewType.None;
            if (!String.IsNullOrEmpty(viewTypeText))
            {
                viewTypeText = viewTypeText.ToLower();
                if (viewTypeText.Contains("details"))
                    viewType = WebFolderViewType.Details;
                else if (viewTypeText.Contains("icons"))
                    viewType = WebFolderViewType.Icons;
                else if (viewTypeText.Contains("thumbnails"))
                    viewType = WebFolderViewType.Thumbnails;
            }
            return viewType;
        }
    }
}
