﻿using System;
using System.IO;

namespace HgCo.WindowsLive.SkyDrive
{
    /// <summary>
    /// Provides webfile content specific data.
    /// </summary>
    public class WebFileInfo : WebFolderItemInfo
    {
        #region Properties

        /// <summary>
        /// Gets the extension.
        /// </summary>
        /// <value>The extension.</value>
        public string Extension
        {
            get
            {
                string extension = String.Empty;
                if (!String.IsNullOrEmpty(PathUrl))
                {
                    extension = Path.GetExtension(PathUrl);
                }
                return extension;
            }
        }

        /// <summary>
        /// Gets the full name (= Name + Extension).
        /// </summary>
        /// <value>The full name.</value>
        public string FullName { get { return String.Concat(Name, Extension); } }

        /// <summary>
        /// Gets or sets ContentType.
        /// </summary>
        /// <value>The ContentType.</value>
        public string ContentType { get; set; }

        #endregion

        #region Constructors

        /// <summary>
        /// Initializes a new instance of the <see cref="WebFileInfo"/> class.
        /// </summary>
        public WebFileInfo()
        {
            ItemType = WebFolderItemType.File;
        }
        
        #endregion
    }
}
