﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;

namespace HgCo.WindowsLive.SkyDrive.Support
{
    /// <summary>
    /// Provides methods for handling <see cref="WebFolderItemInfo"/> specific properties and tasks.
    /// </summary>
    public static class WebFolderItemHelper
    {
        #region Fields
        
        /// <summary>
        /// The regular expression to parse a webfolderitem's path URL from HTML.
        /// </summary>
        private static readonly Regex RegexPathUrl = new Regex("(?i:https?://[^/]+/\\w+.aspx(?<Path>[^?]+))");

        #endregion

        #region Methods

        /// <summary>
        /// Parses the ShareType from a string.
        /// </summary>
        /// <param name="sharedWith">The ShareType text.</param>
        /// <returns>The parsed ShareType.</returns>
        public static WebFolderItemShareType ParseShareType(string sharedWith)
        {
            WebFolderItemShareType shareType = WebFolderItemShareType.None;
            if (!String.IsNullOrEmpty(sharedWith))
            {
                if (sharedWith.Equals("everyone (public)", StringComparison.InvariantCultureIgnoreCase))
                    shareType = WebFolderItemShareType.Public;
                else if (sharedWith.Equals("my network", StringComparison.InvariantCultureIgnoreCase))
                    shareType = WebFolderItemShareType.MyNetwork;
                else if (sharedWith.Equals("people i selected", StringComparison.InvariantCultureIgnoreCase))
                    shareType = WebFolderItemShareType.PeopleSelected;
                else if (sharedWith.Equals("just me", StringComparison.InvariantCultureIgnoreCase))
                    shareType = WebFolderItemShareType.Private;
            }
            return shareType;
        }
        
        /// <summary>
        /// Parses the PathUrl from an URL.
        /// </summary>
        /// <param name="url">The URL to be parsed.</param>
        /// <returns>The parsed PathUrl.</returns>
        public static string ParsePathUrl(string url)
        {
            string pathUrl = null;
            if (!String.IsNullOrEmpty(url))
            {
                string urlDecoded = HtmlDocumentHelper.DecodeUnicodeString(url);
                urlDecoded = HttpUtility.UrlDecode(urlDecoded);
                if (RegexHelper.IsMatch(RegexPathUrl, urlDecoded))
                {
                    Match matchPathUrl = RegexHelper.Match(RegexPathUrl, urlDecoded);
                    pathUrl = matchPathUrl.Groups["Path"].Value.Replace("|", String.Empty);
                }
            }
            return pathUrl;
        }

        #endregion
    }
}
